/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class UpdateItemModifierListsRequest {
    private final List<String> itemIds;
    private final List<String> modifierListsToEnable;
    private final List<String> modifierListsToDisable;

    @JsonCreator
    public UpdateItemModifierListsRequest(@JsonProperty(value="item_ids") List<String> itemIds, @JsonProperty(value="modifier_lists_to_enable") List<String> modifierListsToEnable, @JsonProperty(value="modifier_lists_to_disable") List<String> modifierListsToDisable) {
        this.itemIds = itemIds;
        this.modifierListsToEnable = modifierListsToEnable;
        this.modifierListsToDisable = modifierListsToDisable;
    }

    @JsonGetter(value="item_ids")
    public List<String> getItemIds() {
        return this.itemIds;
    }

    @JsonGetter(value="modifier_lists_to_enable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getModifierListsToEnable() {
        return this.modifierListsToEnable;
    }

    @JsonGetter(value="modifier_lists_to_disable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getModifierListsToDisable() {
        return this.modifierListsToDisable;
    }

    public int hashCode() {
        return Objects.hash(this.itemIds, this.modifierListsToEnable, this.modifierListsToDisable);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateItemModifierListsRequest)) {
            return false;
        }
        UpdateItemModifierListsRequest other = (UpdateItemModifierListsRequest)obj;
        return Objects.equals(this.itemIds, other.itemIds) && Objects.equals(this.modifierListsToEnable, other.modifierListsToEnable) && Objects.equals(this.modifierListsToDisable, other.modifierListsToDisable);
    }

    public String toString() {
        return "UpdateItemModifierListsRequest [itemIds=" + this.itemIds + ", modifierListsToEnable=" + this.modifierListsToEnable + ", modifierListsToDisable=" + this.modifierListsToDisable + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.itemIds).modifierListsToEnable(this.getModifierListsToEnable()).modifierListsToDisable(this.getModifierListsToDisable());
        return builder;
    }

    public static class Builder {
        private List<String> itemIds;
        private List<String> modifierListsToEnable;
        private List<String> modifierListsToDisable;

        public Builder(List<String> itemIds) {
            this.itemIds = itemIds;
        }

        public Builder itemIds(List<String> itemIds) {
            this.itemIds = itemIds;
            return this;
        }

        public Builder modifierListsToEnable(List<String> modifierListsToEnable) {
            this.modifierListsToEnable = modifierListsToEnable;
            return this;
        }

        public Builder modifierListsToDisable(List<String> modifierListsToDisable) {
            this.modifierListsToDisable = modifierListsToDisable;
            return this;
        }

        public UpdateItemModifierListsRequest build() {
            return new UpdateItemModifierListsRequest(this.itemIds, this.modifierListsToEnable, this.modifierListsToDisable);
        }
    }
}

