/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class UpdateItemModifierListsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final String updatedAt;

    @JsonCreator
    public UpdateItemModifierListsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="updated_at") String updatedAt) {
        this.errors = errors;
        this.updatedAt = updatedAt;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateItemModifierListsResponse)) {
            return false;
        }
        UpdateItemModifierListsResponse other = (UpdateItemModifierListsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        return "UpdateItemModifierListsResponse [errors=" + this.errors + ", updatedAt=" + this.updatedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).updatedAt(this.getUpdatedAt());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private String updatedAt;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public UpdateItemModifierListsResponse build() {
            UpdateItemModifierListsResponse model = new UpdateItemModifierListsResponse(this.errors, this.updatedAt);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

