/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class UpdateItemTaxesRequest {
    private final List<String> itemIds;
    private final List<String> taxesToEnable;
    private final List<String> taxesToDisable;

    @JsonCreator
    public UpdateItemTaxesRequest(@JsonProperty(value="item_ids") List<String> itemIds, @JsonProperty(value="taxes_to_enable") List<String> taxesToEnable, @JsonProperty(value="taxes_to_disable") List<String> taxesToDisable) {
        this.itemIds = itemIds;
        this.taxesToEnable = taxesToEnable;
        this.taxesToDisable = taxesToDisable;
    }

    @JsonGetter(value="item_ids")
    public List<String> getItemIds() {
        return this.itemIds;
    }

    @JsonGetter(value="taxes_to_enable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getTaxesToEnable() {
        return this.taxesToEnable;
    }

    @JsonGetter(value="taxes_to_disable")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getTaxesToDisable() {
        return this.taxesToDisable;
    }

    public int hashCode() {
        return Objects.hash(this.itemIds, this.taxesToEnable, this.taxesToDisable);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateItemTaxesRequest)) {
            return false;
        }
        UpdateItemTaxesRequest other = (UpdateItemTaxesRequest)obj;
        return Objects.equals(this.itemIds, other.itemIds) && Objects.equals(this.taxesToEnable, other.taxesToEnable) && Objects.equals(this.taxesToDisable, other.taxesToDisable);
    }

    public String toString() {
        return "UpdateItemTaxesRequest [itemIds=" + this.itemIds + ", taxesToEnable=" + this.taxesToEnable + ", taxesToDisable=" + this.taxesToDisable + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.itemIds).taxesToEnable(this.getTaxesToEnable()).taxesToDisable(this.getTaxesToDisable());
        return builder;
    }

    public static class Builder {
        private List<String> itemIds;
        private List<String> taxesToEnable;
        private List<String> taxesToDisable;

        public Builder(List<String> itemIds) {
            this.itemIds = itemIds;
        }

        public Builder itemIds(List<String> itemIds) {
            this.itemIds = itemIds;
            return this;
        }

        public Builder taxesToEnable(List<String> taxesToEnable) {
            this.taxesToEnable = taxesToEnable;
            return this;
        }

        public Builder taxesToDisable(List<String> taxesToDisable) {
            this.taxesToDisable = taxesToDisable;
            return this;
        }

        public UpdateItemTaxesRequest build() {
            return new UpdateItemTaxesRequest(this.itemIds, this.taxesToEnable, this.taxesToDisable);
        }
    }
}

