/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Order;
import java.util.List;
import java.util.Objects;

public class UpdateOrderRequest {
    private final Order order;
    private final List<String> fieldsToClear;
    private final String idempotencyKey;

    @JsonCreator
    public UpdateOrderRequest(@JsonProperty(value="order") Order order, @JsonProperty(value="fields_to_clear") List<String> fieldsToClear, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.order = order;
        this.fieldsToClear = fieldsToClear;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Order getOrder() {
        return this.order;
    }

    @JsonGetter(value="fields_to_clear")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getFieldsToClear() {
        return this.fieldsToClear;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public int hashCode() {
        return Objects.hash(this.order, this.fieldsToClear, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdateOrderRequest)) {
            return false;
        }
        UpdateOrderRequest other = (UpdateOrderRequest)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.fieldsToClear, other.fieldsToClear) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "UpdateOrderRequest [order=" + this.order + ", fieldsToClear=" + this.fieldsToClear + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().order(this.getOrder()).fieldsToClear(this.getFieldsToClear()).idempotencyKey(this.getIdempotencyKey());
        return builder;
    }

    public static class Builder {
        private Order order;
        private List<String> fieldsToClear;
        private String idempotencyKey;

        public Builder order(Order order) {
            this.order = order;
            return this;
        }

        public Builder fieldsToClear(List<String> fieldsToClear) {
            this.fieldsToClear = fieldsToClear;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public UpdateOrderRequest build() {
            return new UpdateOrderRequest(this.order, this.fieldsToClear, this.idempotencyKey);
        }
    }
}

