/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Payment;
import java.util.Objects;

public class UpdatePaymentRequest {
    private final Payment payment;
    private final String idempotencyKey;

    @JsonCreator
    public UpdatePaymentRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="payment") Payment payment) {
        this.payment = payment;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="payment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Payment getPayment() {
        return this.payment;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public int hashCode() {
        return Objects.hash(this.payment, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpdatePaymentRequest)) {
            return false;
        }
        UpdatePaymentRequest other = (UpdatePaymentRequest)obj;
        return Objects.equals(this.payment, other.payment) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "UpdatePaymentRequest [idempotencyKey=" + this.idempotencyKey + ", payment=" + this.payment + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey).payment(this.getPayment());
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private Payment payment;

        public Builder(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder payment(Payment payment) {
            this.payment = payment;
            return this;
        }

        public UpdatePaymentRequest build() {
            return new UpdatePaymentRequest(this.idempotencyKey, this.payment);
        }
    }
}

