/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogObject;
import java.util.Objects;

public class UpsertCatalogObjectRequest {
    private final String idempotencyKey;
    private final CatalogObject object;

    @JsonCreator
    public UpsertCatalogObjectRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="object") CatalogObject object) {
        this.idempotencyKey = idempotencyKey;
        this.object = object;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="object")
    public CatalogObject getObject() {
        return this.object;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.object);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpsertCatalogObjectRequest)) {
            return false;
        }
        UpsertCatalogObjectRequest other = (UpsertCatalogObjectRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.object, other.object);
    }

    public String toString() {
        return "UpsertCatalogObjectRequest [idempotencyKey=" + this.idempotencyKey + ", object=" + this.object + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.object);
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private CatalogObject object;

        public Builder(String idempotencyKey, CatalogObject object) {
            this.idempotencyKey = idempotencyKey;
            this.object = object;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder object(CatalogObject object) {
            this.object = object;
            return this;
        }

        public UpsertCatalogObjectRequest build() {
            return new UpsertCatalogObjectRequest(this.idempotencyKey, this.object);
        }
    }
}

