/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CatalogIdMapping;
import com.squareup.square.models.CatalogObject;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class UpsertCatalogObjectResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final CatalogObject catalogObject;
    private final List<CatalogIdMapping> idMappings;

    @JsonCreator
    public UpsertCatalogObjectResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="catalog_object") CatalogObject catalogObject, @JsonProperty(value="id_mappings") List<CatalogIdMapping> idMappings) {
        this.errors = errors;
        this.catalogObject = catalogObject;
        this.idMappings = idMappings;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="catalog_object")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CatalogObject getCatalogObject() {
        return this.catalogObject;
    }

    @JsonGetter(value="id_mappings")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogIdMapping> getIdMappings() {
        return this.idMappings;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.catalogObject, this.idMappings);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpsertCatalogObjectResponse)) {
            return false;
        }
        UpsertCatalogObjectResponse other = (UpsertCatalogObjectResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.catalogObject, other.catalogObject) && Objects.equals(this.idMappings, other.idMappings);
    }

    public String toString() {
        return "UpsertCatalogObjectResponse [errors=" + this.errors + ", catalogObject=" + this.catalogObject + ", idMappings=" + this.idMappings + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).catalogObject(this.getCatalogObject()).idMappings(this.getIdMappings());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private CatalogObject catalogObject;
        private List<CatalogIdMapping> idMappings;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder catalogObject(CatalogObject catalogObject) {
            this.catalogObject = catalogObject;
            return this;
        }

        public Builder idMappings(List<CatalogIdMapping> idMappings) {
            this.idMappings = idMappings;
            return this;
        }

        public UpsertCatalogObjectResponse build() {
            UpsertCatalogObjectResponse model = new UpsertCatalogObjectResponse(this.errors, this.catalogObject, this.idMappings);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

