/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CustomAttribute;
import java.util.Objects;

public class UpsertCustomerCustomAttributeRequest {
    private final CustomAttribute customAttribute;
    private final String idempotencyKey;

    @JsonCreator
    public UpsertCustomerCustomAttributeRequest(@JsonProperty(value="custom_attribute") CustomAttribute customAttribute, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.customAttribute = customAttribute;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="custom_attribute")
    public CustomAttribute getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public int hashCode() {
        return Objects.hash(this.customAttribute, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UpsertCustomerCustomAttributeRequest)) {
            return false;
        }
        UpsertCustomerCustomAttributeRequest other = (UpsertCustomerCustomAttributeRequest)obj;
        return Objects.equals(this.customAttribute, other.customAttribute) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "UpsertCustomerCustomAttributeRequest [customAttribute=" + this.customAttribute + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.customAttribute).idempotencyKey(this.getIdempotencyKey());
        return builder;
    }

    public static class Builder {
        private CustomAttribute customAttribute;
        private String idempotencyKey;

        public Builder(CustomAttribute customAttribute) {
            this.customAttribute = customAttribute;
        }

        public Builder customAttribute(CustomAttribute customAttribute) {
            this.customAttribute = customAttribute;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public UpsertCustomerCustomAttributeRequest build() {
            return new UpsertCustomerCustomAttributeRequest(this.customAttribute, this.idempotencyKey);
        }
    }
}

