/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.V1Money;
import java.util.Objects;

public class V1CreateRefundRequest {
    private final String paymentId;
    private final String type;
    private final String reason;
    private final V1Money refundedMoney;
    private final String requestIdempotenceKey;

    @JsonCreator
    public V1CreateRefundRequest(@JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="type") String type, @JsonProperty(value="reason") String reason, @JsonProperty(value="refunded_money") V1Money refundedMoney, @JsonProperty(value="request_idempotence_key") String requestIdempotenceKey) {
        this.paymentId = paymentId;
        this.type = type;
        this.reason = reason;
        this.refundedMoney = refundedMoney;
        this.requestIdempotenceKey = requestIdempotenceKey;
    }

    @JsonGetter(value="payment_id")
    public String getPaymentId() {
        return this.paymentId;
    }

    @JsonGetter(value="type")
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonGetter(value="refunded_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getRefundedMoney() {
        return this.refundedMoney;
    }

    @JsonGetter(value="request_idempotence_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRequestIdempotenceKey() {
        return this.requestIdempotenceKey;
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.type, this.reason, this.refundedMoney, this.requestIdempotenceKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1CreateRefundRequest)) {
            return false;
        }
        V1CreateRefundRequest other = (V1CreateRefundRequest)obj;
        return Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.type, other.type) && Objects.equals(this.reason, other.reason) && Objects.equals(this.refundedMoney, other.refundedMoney) && Objects.equals(this.requestIdempotenceKey, other.requestIdempotenceKey);
    }

    public String toString() {
        return "V1CreateRefundRequest [paymentId=" + this.paymentId + ", type=" + this.type + ", reason=" + this.reason + ", refundedMoney=" + this.refundedMoney + ", requestIdempotenceKey=" + this.requestIdempotenceKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.paymentId, this.type, this.reason).refundedMoney(this.getRefundedMoney()).requestIdempotenceKey(this.getRequestIdempotenceKey());
        return builder;
    }

    public static class Builder {
        private String paymentId;
        private String type;
        private String reason;
        private V1Money refundedMoney;
        private String requestIdempotenceKey;

        public Builder(String paymentId, String type, String reason) {
            this.paymentId = paymentId;
            this.type = type;
            this.reason = reason;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder refundedMoney(V1Money refundedMoney) {
            this.refundedMoney = refundedMoney;
            return this;
        }

        public Builder requestIdempotenceKey(String requestIdempotenceKey) {
            this.requestIdempotenceKey = requestIdempotenceKey;
            return this;
        }

        public V1CreateRefundRequest build() {
            return new V1CreateRefundRequest(this.paymentId, this.type, this.reason, this.refundedMoney, this.requestIdempotenceKey);
        }
    }
}

