/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class V1ListPaymentsRequest {
    private final String order;
    private final String beginTime;
    private final String endTime;
    private final Integer limit;
    private final String batchToken;
    private final Boolean includePartial;

    @JsonCreator
    public V1ListPaymentsRequest(@JsonProperty(value="order") String order, @JsonProperty(value="begin_time") String beginTime, @JsonProperty(value="end_time") String endTime, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="batch_token") String batchToken, @JsonProperty(value="include_partial") Boolean includePartial) {
        this.order = order;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.limit = limit;
        this.batchToken = batchToken;
        this.includePartial = includePartial;
    }

    @JsonGetter(value="order")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getOrder() {
        return this.order;
    }

    @JsonGetter(value="begin_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBeginTime() {
        return this.beginTime;
    }

    @JsonGetter(value="end_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEndTime() {
        return this.endTime;
    }

    @JsonGetter(value="limit")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonGetter(value="batch_token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBatchToken() {
        return this.batchToken;
    }

    @JsonGetter(value="include_partial")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIncludePartial() {
        return this.includePartial;
    }

    public int hashCode() {
        return Objects.hash(this.order, this.beginTime, this.endTime, this.limit, this.batchToken, this.includePartial);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1ListPaymentsRequest)) {
            return false;
        }
        V1ListPaymentsRequest other = (V1ListPaymentsRequest)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.beginTime, other.beginTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals(this.limit, other.limit) && Objects.equals(this.batchToken, other.batchToken) && Objects.equals(this.includePartial, other.includePartial);
    }

    public String toString() {
        return "V1ListPaymentsRequest [order=" + this.order + ", beginTime=" + this.beginTime + ", endTime=" + this.endTime + ", limit=" + this.limit + ", batchToken=" + this.batchToken + ", includePartial=" + this.includePartial + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().order(this.getOrder()).beginTime(this.getBeginTime()).endTime(this.getEndTime()).limit(this.getLimit()).batchToken(this.getBatchToken()).includePartial(this.getIncludePartial());
        return builder;
    }

    public static class Builder {
        private String order;
        private String beginTime;
        private String endTime;
        private Integer limit;
        private String batchToken;
        private Boolean includePartial;

        public Builder order(String order) {
            this.order = order;
            return this;
        }

        public Builder beginTime(String beginTime) {
            this.beginTime = beginTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder batchToken(String batchToken) {
            this.batchToken = batchToken;
            return this;
        }

        public Builder includePartial(Boolean includePartial) {
            this.includePartial = includePartial;
            return this;
        }

        public V1ListPaymentsRequest build() {
            return new V1ListPaymentsRequest(this.order, this.beginTime, this.endTime, this.limit, this.batchToken, this.includePartial);
        }
    }
}

