/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.V1Money;
import java.util.Objects;

public class V1PaymentDiscount {
    private final String name;
    private final V1Money appliedMoney;
    private final String discountId;

    @JsonCreator
    public V1PaymentDiscount(@JsonProperty(value="name") String name, @JsonProperty(value="applied_money") V1Money appliedMoney, @JsonProperty(value="discount_id") String discountId) {
        this.name = name;
        this.appliedMoney = appliedMoney;
        this.discountId = discountId;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonGetter(value="discount_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDiscountId() {
        return this.discountId;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.appliedMoney, this.discountId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1PaymentDiscount)) {
            return false;
        }
        V1PaymentDiscount other = (V1PaymentDiscount)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.appliedMoney, other.appliedMoney) && Objects.equals(this.discountId, other.discountId);
    }

    public String toString() {
        return "V1PaymentDiscount [name=" + this.name + ", appliedMoney=" + this.appliedMoney + ", discountId=" + this.discountId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).appliedMoney(this.getAppliedMoney()).discountId(this.getDiscountId());
        return builder;
    }

    public static class Builder {
        private String name;
        private V1Money appliedMoney;
        private String discountId;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder appliedMoney(V1Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder discountId(String discountId) {
            this.discountId = discountId;
            return this;
        }

        public V1PaymentDiscount build() {
            return new V1PaymentDiscount(this.name, this.appliedMoney, this.discountId);
        }
    }
}

