/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class V1PaymentItemDetail {
    private final String categoryName;
    private final String sku;
    private final String itemId;
    private final String itemVariationId;

    @JsonCreator
    public V1PaymentItemDetail(@JsonProperty(value="category_name") String categoryName, @JsonProperty(value="sku") String sku, @JsonProperty(value="item_id") String itemId, @JsonProperty(value="item_variation_id") String itemVariationId) {
        this.categoryName = categoryName;
        this.sku = sku;
        this.itemId = itemId;
        this.itemVariationId = itemVariationId;
    }

    @JsonGetter(value="category_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCategoryName() {
        return this.categoryName;
    }

    @JsonGetter(value="sku")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSku() {
        return this.sku;
    }

    @JsonGetter(value="item_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getItemId() {
        return this.itemId;
    }

    @JsonGetter(value="item_variation_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getItemVariationId() {
        return this.itemVariationId;
    }

    public int hashCode() {
        return Objects.hash(this.categoryName, this.sku, this.itemId, this.itemVariationId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1PaymentItemDetail)) {
            return false;
        }
        V1PaymentItemDetail other = (V1PaymentItemDetail)obj;
        return Objects.equals(this.categoryName, other.categoryName) && Objects.equals(this.sku, other.sku) && Objects.equals(this.itemId, other.itemId) && Objects.equals(this.itemVariationId, other.itemVariationId);
    }

    public String toString() {
        return "V1PaymentItemDetail [categoryName=" + this.categoryName + ", sku=" + this.sku + ", itemId=" + this.itemId + ", itemVariationId=" + this.itemVariationId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().categoryName(this.getCategoryName()).sku(this.getSku()).itemId(this.getItemId()).itemVariationId(this.getItemVariationId());
        return builder;
    }

    public static class Builder {
        private String categoryName;
        private String sku;
        private String itemId;
        private String itemVariationId;

        public Builder categoryName(String categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        public Builder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public Builder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        public Builder itemVariationId(String itemVariationId) {
            this.itemVariationId = itemVariationId;
            return this;
        }

        public V1PaymentItemDetail build() {
            return new V1PaymentItemDetail(this.categoryName, this.sku, this.itemId, this.itemVariationId);
        }
    }
}

