/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Error;
import com.squareup.square.models.V1Money;
import java.util.List;
import java.util.Objects;

public class V1PaymentTax {
    private final List<Error> errors;
    private final String name;
    private final V1Money appliedMoney;
    private final String rate;
    private final String inclusionType;
    private final String feeId;

    @JsonCreator
    public V1PaymentTax(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="name") String name, @JsonProperty(value="applied_money") V1Money appliedMoney, @JsonProperty(value="rate") String rate, @JsonProperty(value="inclusion_type") String inclusionType, @JsonProperty(value="fee_id") String feeId) {
        this.errors = errors;
        this.name = name;
        this.appliedMoney = appliedMoney;
        this.rate = rate;
        this.inclusionType = inclusionType;
        this.feeId = feeId;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="applied_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getAppliedMoney() {
        return this.appliedMoney;
    }

    @JsonGetter(value="rate")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRate() {
        return this.rate;
    }

    @JsonGetter(value="inclusion_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInclusionType() {
        return this.inclusionType;
    }

    @JsonGetter(value="fee_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getFeeId() {
        return this.feeId;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.name, this.appliedMoney, this.rate, this.inclusionType, this.feeId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1PaymentTax)) {
            return false;
        }
        V1PaymentTax other = (V1PaymentTax)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.name, other.name) && Objects.equals(this.appliedMoney, other.appliedMoney) && Objects.equals(this.rate, other.rate) && Objects.equals(this.inclusionType, other.inclusionType) && Objects.equals(this.feeId, other.feeId);
    }

    public String toString() {
        return "V1PaymentTax [errors=" + this.errors + ", name=" + this.name + ", appliedMoney=" + this.appliedMoney + ", rate=" + this.rate + ", inclusionType=" + this.inclusionType + ", feeId=" + this.feeId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).name(this.getName()).appliedMoney(this.getAppliedMoney()).rate(this.getRate()).inclusionType(this.getInclusionType()).feeId(this.getFeeId());
        return builder;
    }

    public static class Builder {
        private List<Error> errors;
        private String name;
        private V1Money appliedMoney;
        private String rate;
        private String inclusionType;
        private String feeId;

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder appliedMoney(V1Money appliedMoney) {
            this.appliedMoney = appliedMoney;
            return this;
        }

        public Builder rate(String rate) {
            this.rate = rate;
            return this;
        }

        public Builder inclusionType(String inclusionType) {
            this.inclusionType = inclusionType;
            return this;
        }

        public Builder feeId(String feeId) {
            this.feeId = feeId;
            return this;
        }

        public V1PaymentTax build() {
            return new V1PaymentTax(this.errors, this.name, this.appliedMoney, this.rate, this.inclusionType, this.feeId);
        }
    }
}

