/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.V1Money;
import com.squareup.square.models.V1PaymentSurcharge;
import com.squareup.square.models.V1PaymentTax;
import java.util.List;
import java.util.Objects;

public class V1Refund {
    private HttpContext httpContext;
    private final String type;
    private final String reason;
    private final V1Money refundedMoney;
    private final V1Money refundedProcessingFeeMoney;
    private final V1Money refundedTaxMoney;
    private final V1Money refundedAdditiveTaxMoney;
    private final List<V1PaymentTax> refundedAdditiveTax;
    private final V1Money refundedInclusiveTaxMoney;
    private final List<V1PaymentTax> refundedInclusiveTax;
    private final V1Money refundedTipMoney;
    private final V1Money refundedDiscountMoney;
    private final V1Money refundedSurchargeMoney;
    private final List<V1PaymentSurcharge> refundedSurcharges;
    private final String createdAt;
    private final String processedAt;
    private final String paymentId;
    private final String merchantId;
    private final Boolean isExchange;

    @JsonCreator
    public V1Refund(@JsonProperty(value="type") String type, @JsonProperty(value="reason") String reason, @JsonProperty(value="refunded_money") V1Money refundedMoney, @JsonProperty(value="refunded_processing_fee_money") V1Money refundedProcessingFeeMoney, @JsonProperty(value="refunded_tax_money") V1Money refundedTaxMoney, @JsonProperty(value="refunded_additive_tax_money") V1Money refundedAdditiveTaxMoney, @JsonProperty(value="refunded_additive_tax") List<V1PaymentTax> refundedAdditiveTax, @JsonProperty(value="refunded_inclusive_tax_money") V1Money refundedInclusiveTaxMoney, @JsonProperty(value="refunded_inclusive_tax") List<V1PaymentTax> refundedInclusiveTax, @JsonProperty(value="refunded_tip_money") V1Money refundedTipMoney, @JsonProperty(value="refunded_discount_money") V1Money refundedDiscountMoney, @JsonProperty(value="refunded_surcharge_money") V1Money refundedSurchargeMoney, @JsonProperty(value="refunded_surcharges") List<V1PaymentSurcharge> refundedSurcharges, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="processed_at") String processedAt, @JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="merchant_id") String merchantId, @JsonProperty(value="is_exchange") Boolean isExchange) {
        this.type = type;
        this.reason = reason;
        this.refundedMoney = refundedMoney;
        this.refundedProcessingFeeMoney = refundedProcessingFeeMoney;
        this.refundedTaxMoney = refundedTaxMoney;
        this.refundedAdditiveTaxMoney = refundedAdditiveTaxMoney;
        this.refundedAdditiveTax = refundedAdditiveTax;
        this.refundedInclusiveTaxMoney = refundedInclusiveTaxMoney;
        this.refundedInclusiveTax = refundedInclusiveTax;
        this.refundedTipMoney = refundedTipMoney;
        this.refundedDiscountMoney = refundedDiscountMoney;
        this.refundedSurchargeMoney = refundedSurchargeMoney;
        this.refundedSurcharges = refundedSurcharges;
        this.createdAt = createdAt;
        this.processedAt = processedAt;
        this.paymentId = paymentId;
        this.merchantId = merchantId;
        this.isExchange = isExchange;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="reason")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getReason() {
        return this.reason;
    }

    @JsonGetter(value="refunded_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getRefundedMoney() {
        return this.refundedMoney;
    }

    @JsonGetter(value="refunded_processing_fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getRefundedProcessingFeeMoney() {
        return this.refundedProcessingFeeMoney;
    }

    @JsonGetter(value="refunded_tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getRefundedTaxMoney() {
        return this.refundedTaxMoney;
    }

    @JsonGetter(value="refunded_additive_tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getRefundedAdditiveTaxMoney() {
        return this.refundedAdditiveTaxMoney;
    }

    @JsonGetter(value="refunded_additive_tax")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<V1PaymentTax> getRefundedAdditiveTax() {
        return this.refundedAdditiveTax;
    }

    @JsonGetter(value="refunded_inclusive_tax_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getRefundedInclusiveTaxMoney() {
        return this.refundedInclusiveTaxMoney;
    }

    @JsonGetter(value="refunded_inclusive_tax")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<V1PaymentTax> getRefundedInclusiveTax() {
        return this.refundedInclusiveTax;
    }

    @JsonGetter(value="refunded_tip_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getRefundedTipMoney() {
        return this.refundedTipMoney;
    }

    @JsonGetter(value="refunded_discount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getRefundedDiscountMoney() {
        return this.refundedDiscountMoney;
    }

    @JsonGetter(value="refunded_surcharge_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getRefundedSurchargeMoney() {
        return this.refundedSurchargeMoney;
    }

    @JsonGetter(value="refunded_surcharges")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<V1PaymentSurcharge> getRefundedSurcharges() {
        return this.refundedSurcharges;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="processed_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getProcessedAt() {
        return this.processedAt;
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentId() {
        return this.paymentId;
    }

    @JsonGetter(value="merchant_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonGetter(value="is_exchange")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIsExchange() {
        return this.isExchange;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.reason, this.refundedMoney, this.refundedProcessingFeeMoney, this.refundedTaxMoney, this.refundedAdditiveTaxMoney, this.refundedAdditiveTax, this.refundedInclusiveTaxMoney, this.refundedInclusiveTax, this.refundedTipMoney, this.refundedDiscountMoney, this.refundedSurchargeMoney, this.refundedSurcharges, this.createdAt, this.processedAt, this.paymentId, this.merchantId, this.isExchange);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1Refund)) {
            return false;
        }
        V1Refund other = (V1Refund)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.reason, other.reason) && Objects.equals(this.refundedMoney, other.refundedMoney) && Objects.equals(this.refundedProcessingFeeMoney, other.refundedProcessingFeeMoney) && Objects.equals(this.refundedTaxMoney, other.refundedTaxMoney) && Objects.equals(this.refundedAdditiveTaxMoney, other.refundedAdditiveTaxMoney) && Objects.equals(this.refundedAdditiveTax, other.refundedAdditiveTax) && Objects.equals(this.refundedInclusiveTaxMoney, other.refundedInclusiveTaxMoney) && Objects.equals(this.refundedInclusiveTax, other.refundedInclusiveTax) && Objects.equals(this.refundedTipMoney, other.refundedTipMoney) && Objects.equals(this.refundedDiscountMoney, other.refundedDiscountMoney) && Objects.equals(this.refundedSurchargeMoney, other.refundedSurchargeMoney) && Objects.equals(this.refundedSurcharges, other.refundedSurcharges) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.processedAt, other.processedAt) && Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.merchantId, other.merchantId) && Objects.equals(this.isExchange, other.isExchange);
    }

    public String toString() {
        return "V1Refund [type=" + this.type + ", reason=" + this.reason + ", refundedMoney=" + this.refundedMoney + ", refundedProcessingFeeMoney=" + this.refundedProcessingFeeMoney + ", refundedTaxMoney=" + this.refundedTaxMoney + ", refundedAdditiveTaxMoney=" + this.refundedAdditiveTaxMoney + ", refundedAdditiveTax=" + this.refundedAdditiveTax + ", refundedInclusiveTaxMoney=" + this.refundedInclusiveTaxMoney + ", refundedInclusiveTax=" + this.refundedInclusiveTax + ", refundedTipMoney=" + this.refundedTipMoney + ", refundedDiscountMoney=" + this.refundedDiscountMoney + ", refundedSurchargeMoney=" + this.refundedSurchargeMoney + ", refundedSurcharges=" + this.refundedSurcharges + ", createdAt=" + this.createdAt + ", processedAt=" + this.processedAt + ", paymentId=" + this.paymentId + ", merchantId=" + this.merchantId + ", isExchange=" + this.isExchange + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().type(this.getType()).reason(this.getReason()).refundedMoney(this.getRefundedMoney()).refundedProcessingFeeMoney(this.getRefundedProcessingFeeMoney()).refundedTaxMoney(this.getRefundedTaxMoney()).refundedAdditiveTaxMoney(this.getRefundedAdditiveTaxMoney()).refundedAdditiveTax(this.getRefundedAdditiveTax()).refundedInclusiveTaxMoney(this.getRefundedInclusiveTaxMoney()).refundedInclusiveTax(this.getRefundedInclusiveTax()).refundedTipMoney(this.getRefundedTipMoney()).refundedDiscountMoney(this.getRefundedDiscountMoney()).refundedSurchargeMoney(this.getRefundedSurchargeMoney()).refundedSurcharges(this.getRefundedSurcharges()).createdAt(this.getCreatedAt()).processedAt(this.getProcessedAt()).paymentId(this.getPaymentId()).merchantId(this.getMerchantId()).isExchange(this.getIsExchange());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private String type;
        private String reason;
        private V1Money refundedMoney;
        private V1Money refundedProcessingFeeMoney;
        private V1Money refundedTaxMoney;
        private V1Money refundedAdditiveTaxMoney;
        private List<V1PaymentTax> refundedAdditiveTax;
        private V1Money refundedInclusiveTaxMoney;
        private List<V1PaymentTax> refundedInclusiveTax;
        private V1Money refundedTipMoney;
        private V1Money refundedDiscountMoney;
        private V1Money refundedSurchargeMoney;
        private List<V1PaymentSurcharge> refundedSurcharges;
        private String createdAt;
        private String processedAt;
        private String paymentId;
        private String merchantId;
        private Boolean isExchange;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder refundedMoney(V1Money refundedMoney) {
            this.refundedMoney = refundedMoney;
            return this;
        }

        public Builder refundedProcessingFeeMoney(V1Money refundedProcessingFeeMoney) {
            this.refundedProcessingFeeMoney = refundedProcessingFeeMoney;
            return this;
        }

        public Builder refundedTaxMoney(V1Money refundedTaxMoney) {
            this.refundedTaxMoney = refundedTaxMoney;
            return this;
        }

        public Builder refundedAdditiveTaxMoney(V1Money refundedAdditiveTaxMoney) {
            this.refundedAdditiveTaxMoney = refundedAdditiveTaxMoney;
            return this;
        }

        public Builder refundedAdditiveTax(List<V1PaymentTax> refundedAdditiveTax) {
            this.refundedAdditiveTax = refundedAdditiveTax;
            return this;
        }

        public Builder refundedInclusiveTaxMoney(V1Money refundedInclusiveTaxMoney) {
            this.refundedInclusiveTaxMoney = refundedInclusiveTaxMoney;
            return this;
        }

        public Builder refundedInclusiveTax(List<V1PaymentTax> refundedInclusiveTax) {
            this.refundedInclusiveTax = refundedInclusiveTax;
            return this;
        }

        public Builder refundedTipMoney(V1Money refundedTipMoney) {
            this.refundedTipMoney = refundedTipMoney;
            return this;
        }

        public Builder refundedDiscountMoney(V1Money refundedDiscountMoney) {
            this.refundedDiscountMoney = refundedDiscountMoney;
            return this;
        }

        public Builder refundedSurchargeMoney(V1Money refundedSurchargeMoney) {
            this.refundedSurchargeMoney = refundedSurchargeMoney;
            return this;
        }

        public Builder refundedSurcharges(List<V1PaymentSurcharge> refundedSurcharges) {
            this.refundedSurcharges = refundedSurcharges;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder processedAt(String processedAt) {
            this.processedAt = processedAt;
            return this;
        }

        public Builder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder isExchange(Boolean isExchange) {
            this.isExchange = isExchange;
            return this;
        }

        public V1Refund build() {
            V1Refund model = new V1Refund(this.type, this.reason, this.refundedMoney, this.refundedProcessingFeeMoney, this.refundedTaxMoney, this.refundedAdditiveTaxMoney, this.refundedAdditiveTax, this.refundedInclusiveTaxMoney, this.refundedInclusiveTax, this.refundedTipMoney, this.refundedDiscountMoney, this.refundedSurchargeMoney, this.refundedSurcharges, this.createdAt, this.processedAt, this.paymentId, this.merchantId, this.isExchange);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

