/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.V1Money;
import com.squareup.square.models.V1SettlementEntry;
import java.util.List;
import java.util.Objects;

public class V1Settlement {
    private HttpContext httpContext;
    private final String id;
    private final String status;
    private final V1Money totalMoney;
    private final String initiatedAt;
    private final String bankAccountId;
    private final List<V1SettlementEntry> entries;

    @JsonCreator
    public V1Settlement(@JsonProperty(value="id") String id, @JsonProperty(value="status") String status, @JsonProperty(value="total_money") V1Money totalMoney, @JsonProperty(value="initiated_at") String initiatedAt, @JsonProperty(value="bank_account_id") String bankAccountId, @JsonProperty(value="entries") List<V1SettlementEntry> entries) {
        this.id = id;
        this.status = status;
        this.totalMoney = totalMoney;
        this.initiatedAt = initiatedAt;
        this.bankAccountId = bankAccountId;
        this.entries = entries;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    @JsonGetter(value="total_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getTotalMoney() {
        return this.totalMoney;
    }

    @JsonGetter(value="initiated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInitiatedAt() {
        return this.initiatedAt;
    }

    @JsonGetter(value="bank_account_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBankAccountId() {
        return this.bankAccountId;
    }

    @JsonGetter(value="entries")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<V1SettlementEntry> getEntries() {
        return this.entries;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.totalMoney, this.initiatedAt, this.bankAccountId, this.entries);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1Settlement)) {
            return false;
        }
        V1Settlement other = (V1Settlement)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.status, other.status) && Objects.equals(this.totalMoney, other.totalMoney) && Objects.equals(this.initiatedAt, other.initiatedAt) && Objects.equals(this.bankAccountId, other.bankAccountId) && Objects.equals(this.entries, other.entries);
    }

    public String toString() {
        return "V1Settlement [id=" + this.id + ", status=" + this.status + ", totalMoney=" + this.totalMoney + ", initiatedAt=" + this.initiatedAt + ", bankAccountId=" + this.bankAccountId + ", entries=" + this.entries + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).status(this.getStatus()).totalMoney(this.getTotalMoney()).initiatedAt(this.getInitiatedAt()).bankAccountId(this.getBankAccountId()).entries(this.getEntries());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private String id;
        private String status;
        private V1Money totalMoney;
        private String initiatedAt;
        private String bankAccountId;
        private List<V1SettlementEntry> entries;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Builder totalMoney(V1Money totalMoney) {
            this.totalMoney = totalMoney;
            return this;
        }

        public Builder initiatedAt(String initiatedAt) {
            this.initiatedAt = initiatedAt;
            return this;
        }

        public Builder bankAccountId(String bankAccountId) {
            this.bankAccountId = bankAccountId;
            return this;
        }

        public Builder entries(List<V1SettlementEntry> entries) {
            this.entries = entries;
            return this;
        }

        public V1Settlement build() {
            V1Settlement model = new V1Settlement(this.id, this.status, this.totalMoney, this.initiatedAt, this.bankAccountId, this.entries);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

