/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.V1Money;
import java.util.Objects;

public class V1SettlementEntry {
    private final String paymentId;
    private final String type;
    private final V1Money amountMoney;
    private final V1Money feeMoney;

    @JsonCreator
    public V1SettlementEntry(@JsonProperty(value="payment_id") String paymentId, @JsonProperty(value="type") String type, @JsonProperty(value="amount_money") V1Money amountMoney, @JsonProperty(value="fee_money") V1Money feeMoney) {
        this.paymentId = paymentId;
        this.type = type;
        this.amountMoney = amountMoney;
        this.feeMoney = feeMoney;
    }

    @JsonGetter(value="payment_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaymentId() {
        return this.paymentId;
    }

    @JsonGetter(value="type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getType() {
        return this.type;
    }

    @JsonGetter(value="amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getAmountMoney() {
        return this.amountMoney;
    }

    @JsonGetter(value="fee_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public V1Money getFeeMoney() {
        return this.feeMoney;
    }

    public int hashCode() {
        return Objects.hash(this.paymentId, this.type, this.amountMoney, this.feeMoney);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1SettlementEntry)) {
            return false;
        }
        V1SettlementEntry other = (V1SettlementEntry)obj;
        return Objects.equals(this.paymentId, other.paymentId) && Objects.equals(this.type, other.type) && Objects.equals(this.amountMoney, other.amountMoney) && Objects.equals(this.feeMoney, other.feeMoney);
    }

    public String toString() {
        return "V1SettlementEntry [paymentId=" + this.paymentId + ", type=" + this.type + ", amountMoney=" + this.amountMoney + ", feeMoney=" + this.feeMoney + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().paymentId(this.getPaymentId()).type(this.getType()).amountMoney(this.getAmountMoney()).feeMoney(this.getFeeMoney());
        return builder;
    }

    public static class Builder {
        private String paymentId;
        private String type;
        private V1Money amountMoney;
        private V1Money feeMoney;

        public Builder paymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder amountMoney(V1Money amountMoney) {
            this.amountMoney = amountMoney;
            return this;
        }

        public Builder feeMoney(V1Money feeMoney) {
            this.feeMoney = feeMoney;
            return this;
        }

        public V1SettlementEntry build() {
            return new V1SettlementEntry(this.paymentId, this.type, this.amountMoney, this.feeMoney);
        }
    }
}

