/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class V1UpdateOrderRequest {
    private final String action;
    private final String shippedTrackingNumber;
    private final String completedNote;
    private final String refundedNote;
    private final String canceledNote;

    @JsonCreator
    public V1UpdateOrderRequest(@JsonProperty(value="action") String action, @JsonProperty(value="shipped_tracking_number") String shippedTrackingNumber, @JsonProperty(value="completed_note") String completedNote, @JsonProperty(value="refunded_note") String refundedNote, @JsonProperty(value="canceled_note") String canceledNote) {
        this.action = action;
        this.shippedTrackingNumber = shippedTrackingNumber;
        this.completedNote = completedNote;
        this.refundedNote = refundedNote;
        this.canceledNote = canceledNote;
    }

    @JsonGetter(value="action")
    public String getAction() {
        return this.action;
    }

    @JsonGetter(value="shipped_tracking_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getShippedTrackingNumber() {
        return this.shippedTrackingNumber;
    }

    @JsonGetter(value="completed_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCompletedNote() {
        return this.completedNote;
    }

    @JsonGetter(value="refunded_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getRefundedNote() {
        return this.refundedNote;
    }

    @JsonGetter(value="canceled_note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCanceledNote() {
        return this.canceledNote;
    }

    public int hashCode() {
        return Objects.hash(this.action, this.shippedTrackingNumber, this.completedNote, this.refundedNote, this.canceledNote);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof V1UpdateOrderRequest)) {
            return false;
        }
        V1UpdateOrderRequest other = (V1UpdateOrderRequest)obj;
        return Objects.equals(this.action, other.action) && Objects.equals(this.shippedTrackingNumber, other.shippedTrackingNumber) && Objects.equals(this.completedNote, other.completedNote) && Objects.equals(this.refundedNote, other.refundedNote) && Objects.equals(this.canceledNote, other.canceledNote);
    }

    public String toString() {
        return "V1UpdateOrderRequest [action=" + this.action + ", shippedTrackingNumber=" + this.shippedTrackingNumber + ", completedNote=" + this.completedNote + ", refundedNote=" + this.refundedNote + ", canceledNote=" + this.canceledNote + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.action).shippedTrackingNumber(this.getShippedTrackingNumber()).completedNote(this.getCompletedNote()).refundedNote(this.getRefundedNote()).canceledNote(this.getCanceledNote());
        return builder;
    }

    public static class Builder {
        private String action;
        private String shippedTrackingNumber;
        private String completedNote;
        private String refundedNote;
        private String canceledNote;

        public Builder(String action) {
            this.action = action;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder shippedTrackingNumber(String shippedTrackingNumber) {
            this.shippedTrackingNumber = shippedTrackingNumber;
            return this;
        }

        public Builder completedNote(String completedNote) {
            this.completedNote = completedNote;
            return this;
        }

        public Builder refundedNote(String refundedNote) {
            this.refundedNote = refundedNote;
            return this;
        }

        public Builder canceledNote(String canceledNote) {
            this.canceledNote = canceledNote;
            return this;
        }

        public V1UpdateOrderRequest build() {
            return new V1UpdateOrderRequest(this.action, this.shippedTrackingNumber, this.completedNote, this.refundedNote, this.canceledNote);
        }
    }
}

