/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Address;
import com.squareup.square.models.VendorContact;
import java.util.List;
import java.util.Objects;

public class Vendor {
    private final String id;
    private final String createdAt;
    private final String updatedAt;
    private final String name;
    private final Address address;
    private final List<VendorContact> contacts;
    private final String accountNumber;
    private final String note;
    private final Integer version;
    private final String status;

    @JsonCreator
    public Vendor(@JsonProperty(value="id") String id, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt, @JsonProperty(value="name") String name, @JsonProperty(value="address") Address address, @JsonProperty(value="contacts") List<VendorContact> contacts, @JsonProperty(value="account_number") String accountNumber, @JsonProperty(value="note") String note, @JsonProperty(value="version") Integer version, @JsonProperty(value="status") String status) {
        this.id = id;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.name = name;
        this.address = address;
        this.contacts = contacts;
        this.accountNumber = accountNumber;
        this.note = note;
        this.version = version;
        this.status = status;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getAddress() {
        return this.address;
    }

    @JsonGetter(value="contacts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<VendorContact> getContacts() {
        return this.contacts;
    }

    @JsonGetter(value="account_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @JsonGetter(value="note")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getNote() {
        return this.note;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getStatus() {
        return this.status;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.updatedAt, this.name, this.address, this.contacts, this.accountNumber, this.note, this.version, this.status);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Vendor)) {
            return false;
        }
        Vendor other = (Vendor)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt) && Objects.equals(this.name, other.name) && Objects.equals(this.address, other.address) && Objects.equals(this.contacts, other.contacts) && Objects.equals(this.accountNumber, other.accountNumber) && Objects.equals(this.note, other.note) && Objects.equals(this.version, other.version) && Objects.equals(this.status, other.status);
    }

    public String toString() {
        return "Vendor [id=" + this.id + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", name=" + this.name + ", address=" + this.address + ", contacts=" + this.contacts + ", accountNumber=" + this.accountNumber + ", note=" + this.note + ", version=" + this.version + ", status=" + this.status + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt()).name(this.getName()).address(this.getAddress()).contacts(this.getContacts()).accountNumber(this.getAccountNumber()).note(this.getNote()).version(this.getVersion()).status(this.getStatus());
        return builder;
    }

    public static class Builder {
        private String id;
        private String createdAt;
        private String updatedAt;
        private String name;
        private Address address;
        private List<VendorContact> contacts;
        private String accountNumber;
        private String note;
        private Integer version;
        private String status;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Builder contacts(List<VendorContact> contacts) {
            this.contacts = contacts;
            return this;
        }

        public Builder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public Builder note(String note) {
            this.note = note;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            return this;
        }

        public Vendor build() {
            return new Vendor(this.id, this.createdAt, this.updatedAt, this.name, this.address, this.contacts, this.accountNumber, this.note, this.version, this.status);
        }
    }
}

