/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class VendorContact {
    private final String id;
    private final String name;
    private final String emailAddress;
    private final String phoneNumber;
    private final Boolean removed;
    private final int ordinal;

    @JsonCreator
    public VendorContact(@JsonProperty(value="ordinal") int ordinal, @JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="email_address") String emailAddress, @JsonProperty(value="phone_number") String phoneNumber, @JsonProperty(value="removed") Boolean removed) {
        this.id = id;
        this.name = name;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.removed = removed;
        this.ordinal = ordinal;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonGetter(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonGetter(value="removed")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getRemoved() {
        return this.removed;
    }

    @JsonGetter(value="ordinal")
    public int getOrdinal() {
        return this.ordinal;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.emailAddress, this.phoneNumber, this.removed, this.ordinal);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VendorContact)) {
            return false;
        }
        VendorContact other = (VendorContact)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.emailAddress, other.emailAddress) && Objects.equals(this.phoneNumber, other.phoneNumber) && Objects.equals(this.removed, other.removed) && Objects.equals(this.ordinal, other.ordinal);
    }

    public String toString() {
        return "VendorContact [ordinal=" + this.ordinal + ", id=" + this.id + ", name=" + this.name + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ", removed=" + this.removed + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.ordinal).id(this.getId()).name(this.getName()).emailAddress(this.getEmailAddress()).phoneNumber(this.getPhoneNumber()).removed(this.getRemoved());
        return builder;
    }

    public static class Builder {
        private int ordinal;
        private String id;
        private String name;
        private String emailAddress;
        private String phoneNumber;
        private Boolean removed;

        public Builder(int ordinal) {
            this.ordinal = ordinal;
        }

        public Builder ordinal(int ordinal) {
            this.ordinal = ordinal;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder removed(Boolean removed) {
            this.removed = removed;
            return this;
        }

        public VendorContact build() {
            return new VendorContact(this.ordinal, this.id, this.name, this.emailAddress, this.phoneNumber, this.removed);
        }
    }
}

