/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.JobAssignment;
import java.util.List;
import java.util.Objects;

public class WageSetting {
    private final String teamMemberId;
    private final List<JobAssignment> jobAssignments;
    private final Boolean isOvertimeExempt;
    private final Integer version;
    private final String createdAt;
    private final String updatedAt;

    @JsonCreator
    public WageSetting(@JsonProperty(value="team_member_id") String teamMemberId, @JsonProperty(value="job_assignments") List<JobAssignment> jobAssignments, @JsonProperty(value="is_overtime_exempt") Boolean isOvertimeExempt, @JsonProperty(value="version") Integer version, @JsonProperty(value="created_at") String createdAt, @JsonProperty(value="updated_at") String updatedAt) {
        this.teamMemberId = teamMemberId;
        this.jobAssignments = jobAssignments;
        this.isOvertimeExempt = isOvertimeExempt;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    @JsonGetter(value="team_member_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonGetter(value="job_assignments")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<JobAssignment> getJobAssignments() {
        return this.jobAssignments;
    }

    @JsonGetter(value="is_overtime_exempt")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getIsOvertimeExempt() {
        return this.isOvertimeExempt;
    }

    @JsonGetter(value="version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getVersion() {
        return this.version;
    }

    @JsonGetter(value="created_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreatedAt() {
        return this.createdAt;
    }

    @JsonGetter(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public int hashCode() {
        return Objects.hash(this.teamMemberId, this.jobAssignments, this.isOvertimeExempt, this.version, this.createdAt, this.updatedAt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WageSetting)) {
            return false;
        }
        WageSetting other = (WageSetting)obj;
        return Objects.equals(this.teamMemberId, other.teamMemberId) && Objects.equals(this.jobAssignments, other.jobAssignments) && Objects.equals(this.isOvertimeExempt, other.isOvertimeExempt) && Objects.equals(this.version, other.version) && Objects.equals(this.createdAt, other.createdAt) && Objects.equals(this.updatedAt, other.updatedAt);
    }

    public String toString() {
        return "WageSetting [teamMemberId=" + this.teamMemberId + ", jobAssignments=" + this.jobAssignments + ", isOvertimeExempt=" + this.isOvertimeExempt + ", version=" + this.version + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().teamMemberId(this.getTeamMemberId()).jobAssignments(this.getJobAssignments()).isOvertimeExempt(this.getIsOvertimeExempt()).version(this.getVersion()).createdAt(this.getCreatedAt()).updatedAt(this.getUpdatedAt());
        return builder;
    }

    public static class Builder {
        private String teamMemberId;
        private List<JobAssignment> jobAssignments;
        private Boolean isOvertimeExempt;
        private Integer version;
        private String createdAt;
        private String updatedAt;

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder jobAssignments(List<JobAssignment> jobAssignments) {
            this.jobAssignments = jobAssignments;
            return this;
        }

        public Builder isOvertimeExempt(Boolean isOvertimeExempt) {
            this.isOvertimeExempt = isOvertimeExempt;
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public WageSetting build() {
            return new WageSetting(this.teamMemberId, this.jobAssignments, this.isOvertimeExempt, this.version, this.createdAt, this.updatedAt);
        }
    }
}

