/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.utilities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.squareup.square.ApiHelper;
import java.io.IOException;

public class JsonObject {
    @JsonValue
    private JsonNode jsonNode;

    @JsonCreator
    private JsonObject(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    public static JsonObject fromJsonString(String jsonString) throws IOException {
        if (jsonString == null) {
            return new JsonObject(null);
        }
        JsonNode node = ApiHelper.mapper.readTree(jsonString);
        if (node.isObject()) {
            return new JsonObject(node);
        }
        throw new IOException("Provided JSON string must contain a valid JSON object.");
    }

    public Object getStoredObject() {
        return ApiHelper.deserializeAsObject(this.toString());
    }

    public String toString() {
        try {
            return ApiHelper.mapper.writeValueAsString((Object)this.jsonNode);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }
}

