/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.utilities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.squareup.square.ApiHelper;
import java.util.List;

public class JsonValue {
    @com.fasterxml.jackson.annotation.JsonValue
    private JsonNode value;

    @JsonCreator
    private JsonValue(JsonNode value) {
        this.value = value;
    }

    public static JsonValue fromString(String value) {
        if (value == null) {
            return new JsonValue(null);
        }
        return new JsonValue((JsonNode)TextNode.valueOf((String)value));
    }

    public static JsonValue fromBoolean(Boolean value) {
        if (value == null) {
            return new JsonValue(null);
        }
        return new JsonValue((JsonNode)BooleanNode.valueOf((boolean)value));
    }

    public static JsonValue fromInteger(Integer value) {
        if (value == null) {
            return new JsonValue(null);
        }
        return new JsonValue((JsonNode)IntNode.valueOf((int)value));
    }

    public static JsonValue fromLong(Long value) {
        if (value == null) {
            return new JsonValue(null);
        }
        return new JsonValue((JsonNode)LongNode.valueOf((long)value));
    }

    public static JsonValue fromDouble(Double value) {
        if (value == null) {
            return new JsonValue(null);
        }
        return new JsonValue((JsonNode)DoubleNode.valueOf((double)value));
    }

    public static JsonValue fromObject(Object value) {
        if (value == null) {
            return new JsonValue(null);
        }
        return new JsonValue(ApiHelper.mapper.valueToTree(value));
    }

    public static <T> JsonValue fromArray(List<T> values) {
        if (values == null) {
            return new JsonValue(null);
        }
        return new JsonValue(ApiHelper.mapper.valueToTree(values));
    }

    public Object getStoredObject() {
        return ApiHelper.deserializeAsObject(this.toString());
    }

    public String toString() {
        try {
            return ApiHelper.mapper.writeValueAsString((Object)this.value);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }
}

