/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BankAccountsApi;
import com.squareup.square.api.BaseApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.GetBankAccountByV1IdResponse;
import com.squareup.square.models.GetBankAccountResponse;
import com.squareup.square.models.ListBankAccountsResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultBankAccountsApi
extends BaseApi
implements BankAccountsApi {
    public DefaultBankAccountsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListBankAccountsResponse listBankAccounts(String cursor, Integer limit, String locationId) throws ApiException, IOException {
        return (ListBankAccountsResponse)this.prepareListBankAccountsRequest(cursor, limit, locationId).execute();
    }

    @Override
    public CompletableFuture<ListBankAccountsResponse> listBankAccountsAsync(String cursor, Integer limit, String locationId) {
        try {
            return this.prepareListBankAccountsRequest(cursor, limit, locationId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListBankAccountsResponse, ApiException> prepareListBankAccountsRequest(String cursor, Integer limit, String locationId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bank-accounts").queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("location_id").value((Object)locationId).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListBankAccountsResponse)ApiHelper.deserialize((String)response, ListBankAccountsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetBankAccountByV1IdResponse getBankAccountByV1Id(String v1BankAccountId) throws ApiException, IOException {
        return (GetBankAccountByV1IdResponse)this.prepareGetBankAccountByV1IdRequest(v1BankAccountId).execute();
    }

    @Override
    public CompletableFuture<GetBankAccountByV1IdResponse> getBankAccountByV1IdAsync(String v1BankAccountId) {
        try {
            return this.prepareGetBankAccountByV1IdRequest(v1BankAccountId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetBankAccountByV1IdResponse, ApiException> prepareGetBankAccountByV1IdRequest(String v1BankAccountId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bank-accounts/by-v1-id/{v1_bank_account_id}").templateParam(param -> param.key("v1_bank_account_id").value((Object)v1BankAccountId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetBankAccountByV1IdResponse)ApiHelper.deserialize((String)response, GetBankAccountByV1IdResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetBankAccountResponse getBankAccount(String bankAccountId) throws ApiException, IOException {
        return (GetBankAccountResponse)this.prepareGetBankAccountRequest(bankAccountId).execute();
    }

    @Override
    public CompletableFuture<GetBankAccountResponse> getBankAccountAsync(String bankAccountId) {
        try {
            return this.prepareGetBankAccountRequest(bankAccountId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetBankAccountResponse, ApiException> prepareGetBankAccountRequest(String bankAccountId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bank-accounts/{bank_account_id}").templateParam(param -> param.key("bank_account_id").value((Object)bankAccountId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetBankAccountResponse)ApiHelper.deserialize((String)response, GetBankAccountResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

