/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.BookingsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.CancelBookingRequest;
import com.squareup.square.models.CancelBookingResponse;
import com.squareup.square.models.CreateBookingRequest;
import com.squareup.square.models.CreateBookingResponse;
import com.squareup.square.models.ListBookingsResponse;
import com.squareup.square.models.ListTeamMemberBookingProfilesResponse;
import com.squareup.square.models.RetrieveBookingResponse;
import com.squareup.square.models.RetrieveBusinessBookingProfileResponse;
import com.squareup.square.models.RetrieveTeamMemberBookingProfileResponse;
import com.squareup.square.models.SearchAvailabilityRequest;
import com.squareup.square.models.SearchAvailabilityResponse;
import com.squareup.square.models.UpdateBookingRequest;
import com.squareup.square.models.UpdateBookingResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultBookingsApi
extends BaseApi
implements BookingsApi {
    public DefaultBookingsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListBookingsResponse listBookings(Integer limit, String cursor, String teamMemberId, String locationId, String startAtMin, String startAtMax) throws ApiException, IOException {
        return (ListBookingsResponse)this.prepareListBookingsRequest(limit, cursor, teamMemberId, locationId, startAtMin, startAtMax).execute();
    }

    @Override
    public CompletableFuture<ListBookingsResponse> listBookingsAsync(Integer limit, String cursor, String teamMemberId, String locationId, String startAtMin, String startAtMax) {
        try {
            return this.prepareListBookingsRequest(limit, cursor, teamMemberId, locationId, startAtMin, startAtMax).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListBookingsResponse, ApiException> prepareListBookingsRequest(Integer limit, String cursor, String teamMemberId, String locationId, String startAtMin, String startAtMax) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings").queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("team_member_id").value((Object)teamMemberId).isRequired(false)).queryParam(param -> param.key("location_id").value((Object)locationId).isRequired(false)).queryParam(param -> param.key("start_at_min").value((Object)startAtMin).isRequired(false)).queryParam(param -> param.key("start_at_max").value((Object)startAtMax).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListBookingsResponse)ApiHelper.deserialize((String)response, ListBookingsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateBookingResponse createBooking(CreateBookingRequest body) throws ApiException, IOException {
        return (CreateBookingResponse)this.prepareCreateBookingRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateBookingResponse> createBookingAsync(CreateBookingRequest body) {
        try {
            return this.prepareCreateBookingRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateBookingResponse, ApiException> prepareCreateBookingRequest(CreateBookingRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateBookingResponse)ApiHelper.deserialize((String)response, CreateBookingResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchAvailabilityResponse searchAvailability(SearchAvailabilityRequest body) throws ApiException, IOException {
        return (SearchAvailabilityResponse)this.prepareSearchAvailabilityRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchAvailabilityResponse> searchAvailabilityAsync(SearchAvailabilityRequest body) {
        try {
            return this.prepareSearchAvailabilityRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchAvailabilityResponse, ApiException> prepareSearchAvailabilityRequest(SearchAvailabilityRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/availability/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchAvailabilityResponse)ApiHelper.deserialize((String)response, SearchAvailabilityResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveBusinessBookingProfileResponse retrieveBusinessBookingProfile() throws ApiException, IOException {
        return (RetrieveBusinessBookingProfileResponse)this.prepareRetrieveBusinessBookingProfileRequest().execute();
    }

    @Override
    public CompletableFuture<RetrieveBusinessBookingProfileResponse> retrieveBusinessBookingProfileAsync() {
        try {
            return this.prepareRetrieveBusinessBookingProfileRequest().executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveBusinessBookingProfileResponse, ApiException> prepareRetrieveBusinessBookingProfileRequest() throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/business-booking-profile").headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveBusinessBookingProfileResponse)ApiHelper.deserialize((String)response, RetrieveBusinessBookingProfileResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListTeamMemberBookingProfilesResponse listTeamMemberBookingProfiles(Boolean bookableOnly, Integer limit, String cursor, String locationId) throws ApiException, IOException {
        return (ListTeamMemberBookingProfilesResponse)this.prepareListTeamMemberBookingProfilesRequest(bookableOnly, limit, cursor, locationId).execute();
    }

    @Override
    public CompletableFuture<ListTeamMemberBookingProfilesResponse> listTeamMemberBookingProfilesAsync(Boolean bookableOnly, Integer limit, String cursor, String locationId) {
        try {
            return this.prepareListTeamMemberBookingProfilesRequest(bookableOnly, limit, cursor, locationId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListTeamMemberBookingProfilesResponse, ApiException> prepareListTeamMemberBookingProfilesRequest(Boolean bookableOnly, Integer limit, String cursor, String locationId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/team-member-booking-profiles").queryParam(param -> param.key("bookable_only").value((Object)(bookableOnly != null ? bookableOnly : false)).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("location_id").value((Object)locationId).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListTeamMemberBookingProfilesResponse)ApiHelper.deserialize((String)response, ListTeamMemberBookingProfilesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveTeamMemberBookingProfileResponse retrieveTeamMemberBookingProfile(String teamMemberId) throws ApiException, IOException {
        return (RetrieveTeamMemberBookingProfileResponse)this.prepareRetrieveTeamMemberBookingProfileRequest(teamMemberId).execute();
    }

    @Override
    public CompletableFuture<RetrieveTeamMemberBookingProfileResponse> retrieveTeamMemberBookingProfileAsync(String teamMemberId) {
        try {
            return this.prepareRetrieveTeamMemberBookingProfileRequest(teamMemberId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveTeamMemberBookingProfileResponse, ApiException> prepareRetrieveTeamMemberBookingProfileRequest(String teamMemberId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/team-member-booking-profiles/{team_member_id}").templateParam(param -> param.key("team_member_id").value((Object)teamMemberId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveTeamMemberBookingProfileResponse)ApiHelper.deserialize((String)response, RetrieveTeamMemberBookingProfileResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveBookingResponse retrieveBooking(String bookingId) throws ApiException, IOException {
        return (RetrieveBookingResponse)this.prepareRetrieveBookingRequest(bookingId).execute();
    }

    @Override
    public CompletableFuture<RetrieveBookingResponse> retrieveBookingAsync(String bookingId) {
        try {
            return this.prepareRetrieveBookingRequest(bookingId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveBookingResponse, ApiException> prepareRetrieveBookingRequest(String bookingId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/{booking_id}").templateParam(param -> param.key("booking_id").value((Object)bookingId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveBookingResponse)ApiHelper.deserialize((String)response, RetrieveBookingResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateBookingResponse updateBooking(String bookingId, UpdateBookingRequest body) throws ApiException, IOException {
        return (UpdateBookingResponse)this.prepareUpdateBookingRequest(bookingId, body).execute();
    }

    @Override
    public CompletableFuture<UpdateBookingResponse> updateBookingAsync(String bookingId, UpdateBookingRequest body) {
        try {
            return this.prepareUpdateBookingRequest(bookingId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateBookingResponse, ApiException> prepareUpdateBookingRequest(String bookingId, UpdateBookingRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/{booking_id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("booking_id").value((Object)bookingId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateBookingResponse)ApiHelper.deserialize((String)response, UpdateBookingResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CancelBookingResponse cancelBooking(String bookingId, CancelBookingRequest body) throws ApiException, IOException {
        return (CancelBookingResponse)this.prepareCancelBookingRequest(bookingId, body).execute();
    }

    @Override
    public CompletableFuture<CancelBookingResponse> cancelBookingAsync(String bookingId, CancelBookingRequest body) {
        try {
            return this.prepareCancelBookingRequest(bookingId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CancelBookingResponse, ApiException> prepareCancelBookingRequest(String bookingId, CancelBookingRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/bookings/{booking_id}/cancel").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("booking_id").value((Object)bookingId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CancelBookingResponse)ApiHelper.deserialize((String)response, CancelBookingResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

