/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.CustomerCustomAttributesApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.BulkUpsertCustomerCustomAttributesRequest;
import com.squareup.square.models.BulkUpsertCustomerCustomAttributesResponse;
import com.squareup.square.models.CreateCustomerCustomAttributeDefinitionRequest;
import com.squareup.square.models.CreateCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.models.DeleteCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.models.DeleteCustomerCustomAttributeResponse;
import com.squareup.square.models.ListCustomerCustomAttributeDefinitionsResponse;
import com.squareup.square.models.ListCustomerCustomAttributesResponse;
import com.squareup.square.models.RetrieveCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.models.RetrieveCustomerCustomAttributeResponse;
import com.squareup.square.models.UpdateCustomerCustomAttributeDefinitionRequest;
import com.squareup.square.models.UpdateCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.models.UpsertCustomerCustomAttributeRequest;
import com.squareup.square.models.UpsertCustomerCustomAttributeResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultCustomerCustomAttributesApi
extends BaseApi
implements CustomerCustomAttributesApi {
    public DefaultCustomerCustomAttributesApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListCustomerCustomAttributeDefinitionsResponse listCustomerCustomAttributeDefinitions(Integer limit, String cursor) throws ApiException, IOException {
        return (ListCustomerCustomAttributeDefinitionsResponse)this.prepareListCustomerCustomAttributeDefinitionsRequest(limit, cursor).execute();
    }

    @Override
    public CompletableFuture<ListCustomerCustomAttributeDefinitionsResponse> listCustomerCustomAttributeDefinitionsAsync(Integer limit, String cursor) {
        try {
            return this.prepareListCustomerCustomAttributeDefinitionsRequest(limit, cursor).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListCustomerCustomAttributeDefinitionsResponse, ApiException> prepareListCustomerCustomAttributeDefinitionsRequest(Integer limit, String cursor) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/custom-attribute-definitions").queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListCustomerCustomAttributeDefinitionsResponse)ApiHelper.deserialize((String)response, ListCustomerCustomAttributeDefinitionsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateCustomerCustomAttributeDefinitionResponse createCustomerCustomAttributeDefinition(CreateCustomerCustomAttributeDefinitionRequest body) throws ApiException, IOException {
        return (CreateCustomerCustomAttributeDefinitionResponse)this.prepareCreateCustomerCustomAttributeDefinitionRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateCustomerCustomAttributeDefinitionResponse> createCustomerCustomAttributeDefinitionAsync(CreateCustomerCustomAttributeDefinitionRequest body) {
        try {
            return this.prepareCreateCustomerCustomAttributeDefinitionRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateCustomerCustomAttributeDefinitionResponse, ApiException> prepareCreateCustomerCustomAttributeDefinitionRequest(CreateCustomerCustomAttributeDefinitionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/custom-attribute-definitions").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateCustomerCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, CreateCustomerCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteCustomerCustomAttributeDefinitionResponse deleteCustomerCustomAttributeDefinition(String key) throws ApiException, IOException {
        return (DeleteCustomerCustomAttributeDefinitionResponse)this.prepareDeleteCustomerCustomAttributeDefinitionRequest(key).execute();
    }

    @Override
    public CompletableFuture<DeleteCustomerCustomAttributeDefinitionResponse> deleteCustomerCustomAttributeDefinitionAsync(String key) {
        try {
            return this.prepareDeleteCustomerCustomAttributeDefinitionRequest(key).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteCustomerCustomAttributeDefinitionResponse, ApiException> prepareDeleteCustomerCustomAttributeDefinitionRequest(String key) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/custom-attribute-definitions/{key}").templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteCustomerCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, DeleteCustomerCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveCustomerCustomAttributeDefinitionResponse retrieveCustomerCustomAttributeDefinition(String key, Integer version) throws ApiException, IOException {
        return (RetrieveCustomerCustomAttributeDefinitionResponse)this.prepareRetrieveCustomerCustomAttributeDefinitionRequest(key, version).execute();
    }

    @Override
    public CompletableFuture<RetrieveCustomerCustomAttributeDefinitionResponse> retrieveCustomerCustomAttributeDefinitionAsync(String key, Integer version) {
        try {
            return this.prepareRetrieveCustomerCustomAttributeDefinitionRequest(key, version).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveCustomerCustomAttributeDefinitionResponse, ApiException> prepareRetrieveCustomerCustomAttributeDefinitionRequest(String key, Integer version) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/custom-attribute-definitions/{key}").queryParam(param -> param.key("version").value((Object)version).isRequired(false)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveCustomerCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, RetrieveCustomerCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateCustomerCustomAttributeDefinitionResponse updateCustomerCustomAttributeDefinition(String key, UpdateCustomerCustomAttributeDefinitionRequest body) throws ApiException, IOException {
        return (UpdateCustomerCustomAttributeDefinitionResponse)this.prepareUpdateCustomerCustomAttributeDefinitionRequest(key, body).execute();
    }

    @Override
    public CompletableFuture<UpdateCustomerCustomAttributeDefinitionResponse> updateCustomerCustomAttributeDefinitionAsync(String key, UpdateCustomerCustomAttributeDefinitionRequest body) {
        try {
            return this.prepareUpdateCustomerCustomAttributeDefinitionRequest(key, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateCustomerCustomAttributeDefinitionResponse, ApiException> prepareUpdateCustomerCustomAttributeDefinitionRequest(String key, UpdateCustomerCustomAttributeDefinitionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/custom-attribute-definitions/{key}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateCustomerCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, UpdateCustomerCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkUpsertCustomerCustomAttributesResponse bulkUpsertCustomerCustomAttributes(BulkUpsertCustomerCustomAttributesRequest body) throws ApiException, IOException {
        return (BulkUpsertCustomerCustomAttributesResponse)this.prepareBulkUpsertCustomerCustomAttributesRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkUpsertCustomerCustomAttributesResponse> bulkUpsertCustomerCustomAttributesAsync(BulkUpsertCustomerCustomAttributesRequest body) {
        try {
            return this.prepareBulkUpsertCustomerCustomAttributesRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkUpsertCustomerCustomAttributesResponse, ApiException> prepareBulkUpsertCustomerCustomAttributesRequest(BulkUpsertCustomerCustomAttributesRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/custom-attributes/bulk-upsert").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkUpsertCustomerCustomAttributesResponse)ApiHelper.deserialize((String)response, BulkUpsertCustomerCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListCustomerCustomAttributesResponse listCustomerCustomAttributes(String customerId, Integer limit, String cursor, Boolean withDefinitions) throws ApiException, IOException {
        return (ListCustomerCustomAttributesResponse)this.prepareListCustomerCustomAttributesRequest(customerId, limit, cursor, withDefinitions).execute();
    }

    @Override
    public CompletableFuture<ListCustomerCustomAttributesResponse> listCustomerCustomAttributesAsync(String customerId, Integer limit, String cursor, Boolean withDefinitions) {
        try {
            return this.prepareListCustomerCustomAttributesRequest(customerId, limit, cursor, withDefinitions).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListCustomerCustomAttributesResponse, ApiException> prepareListCustomerCustomAttributesRequest(String customerId, Integer limit, String cursor, Boolean withDefinitions) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/{customer_id}/custom-attributes").queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("with_definitions").value((Object)(withDefinitions != null ? withDefinitions : false)).isRequired(false)).templateParam(param -> param.key("customer_id").value((Object)customerId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListCustomerCustomAttributesResponse)ApiHelper.deserialize((String)response, ListCustomerCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteCustomerCustomAttributeResponse deleteCustomerCustomAttribute(String customerId, String key) throws ApiException, IOException {
        return (DeleteCustomerCustomAttributeResponse)this.prepareDeleteCustomerCustomAttributeRequest(customerId, key).execute();
    }

    @Override
    public CompletableFuture<DeleteCustomerCustomAttributeResponse> deleteCustomerCustomAttributeAsync(String customerId, String key) {
        try {
            return this.prepareDeleteCustomerCustomAttributeRequest(customerId, key).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteCustomerCustomAttributeResponse, ApiException> prepareDeleteCustomerCustomAttributeRequest(String customerId, String key) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/{customer_id}/custom-attributes/{key}").templateParam(param -> param.key("customer_id").value((Object)customerId).shouldEncode(true)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteCustomerCustomAttributeResponse)ApiHelper.deserialize((String)response, DeleteCustomerCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveCustomerCustomAttributeResponse retrieveCustomerCustomAttribute(String customerId, String key, Boolean withDefinition, Integer version) throws ApiException, IOException {
        return (RetrieveCustomerCustomAttributeResponse)this.prepareRetrieveCustomerCustomAttributeRequest(customerId, key, withDefinition, version).execute();
    }

    @Override
    public CompletableFuture<RetrieveCustomerCustomAttributeResponse> retrieveCustomerCustomAttributeAsync(String customerId, String key, Boolean withDefinition, Integer version) {
        try {
            return this.prepareRetrieveCustomerCustomAttributeRequest(customerId, key, withDefinition, version).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveCustomerCustomAttributeResponse, ApiException> prepareRetrieveCustomerCustomAttributeRequest(String customerId, String key, Boolean withDefinition, Integer version) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/{customer_id}/custom-attributes/{key}").queryParam(param -> param.key("with_definition").value((Object)(withDefinition != null ? withDefinition : false)).isRequired(false)).queryParam(param -> param.key("version").value((Object)version).isRequired(false)).templateParam(param -> param.key("customer_id").value((Object)customerId).shouldEncode(true)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveCustomerCustomAttributeResponse)ApiHelper.deserialize((String)response, RetrieveCustomerCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpsertCustomerCustomAttributeResponse upsertCustomerCustomAttribute(String customerId, String key, UpsertCustomerCustomAttributeRequest body) throws ApiException, IOException {
        return (UpsertCustomerCustomAttributeResponse)this.prepareUpsertCustomerCustomAttributeRequest(customerId, key, body).execute();
    }

    @Override
    public CompletableFuture<UpsertCustomerCustomAttributeResponse> upsertCustomerCustomAttributeAsync(String customerId, String key, UpsertCustomerCustomAttributeRequest body) {
        try {
            return this.prepareUpsertCustomerCustomAttributeRequest(customerId, key, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpsertCustomerCustomAttributeResponse, ApiException> prepareUpsertCustomerCustomAttributeRequest(String customerId, String key, UpsertCustomerCustomAttributeRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/{customer_id}/custom-attributes/{key}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("customer_id").value((Object)customerId).shouldEncode(true)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpsertCustomerCustomAttributeResponse)ApiHelper.deserialize((String)response, UpsertCustomerCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

