/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.CustomerGroupsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.CreateCustomerGroupRequest;
import com.squareup.square.models.CreateCustomerGroupResponse;
import com.squareup.square.models.DeleteCustomerGroupResponse;
import com.squareup.square.models.ListCustomerGroupsResponse;
import com.squareup.square.models.RetrieveCustomerGroupResponse;
import com.squareup.square.models.UpdateCustomerGroupRequest;
import com.squareup.square.models.UpdateCustomerGroupResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultCustomerGroupsApi
extends BaseApi
implements CustomerGroupsApi {
    public DefaultCustomerGroupsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListCustomerGroupsResponse listCustomerGroups(String cursor, Integer limit) throws ApiException, IOException {
        return (ListCustomerGroupsResponse)this.prepareListCustomerGroupsRequest(cursor, limit).execute();
    }

    @Override
    public CompletableFuture<ListCustomerGroupsResponse> listCustomerGroupsAsync(String cursor, Integer limit) {
        try {
            return this.prepareListCustomerGroupsRequest(cursor, limit).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListCustomerGroupsResponse, ApiException> prepareListCustomerGroupsRequest(String cursor, Integer limit) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/groups").queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListCustomerGroupsResponse)ApiHelper.deserialize((String)response, ListCustomerGroupsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateCustomerGroupResponse createCustomerGroup(CreateCustomerGroupRequest body) throws ApiException, IOException {
        return (CreateCustomerGroupResponse)this.prepareCreateCustomerGroupRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateCustomerGroupResponse> createCustomerGroupAsync(CreateCustomerGroupRequest body) {
        try {
            return this.prepareCreateCustomerGroupRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateCustomerGroupResponse, ApiException> prepareCreateCustomerGroupRequest(CreateCustomerGroupRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/groups").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateCustomerGroupResponse)ApiHelper.deserialize((String)response, CreateCustomerGroupResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteCustomerGroupResponse deleteCustomerGroup(String groupId) throws ApiException, IOException {
        return (DeleteCustomerGroupResponse)this.prepareDeleteCustomerGroupRequest(groupId).execute();
    }

    @Override
    public CompletableFuture<DeleteCustomerGroupResponse> deleteCustomerGroupAsync(String groupId) {
        try {
            return this.prepareDeleteCustomerGroupRequest(groupId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteCustomerGroupResponse, ApiException> prepareDeleteCustomerGroupRequest(String groupId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/groups/{group_id}").templateParam(param -> param.key("group_id").value((Object)groupId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteCustomerGroupResponse)ApiHelper.deserialize((String)response, DeleteCustomerGroupResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveCustomerGroupResponse retrieveCustomerGroup(String groupId) throws ApiException, IOException {
        return (RetrieveCustomerGroupResponse)this.prepareRetrieveCustomerGroupRequest(groupId).execute();
    }

    @Override
    public CompletableFuture<RetrieveCustomerGroupResponse> retrieveCustomerGroupAsync(String groupId) {
        try {
            return this.prepareRetrieveCustomerGroupRequest(groupId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveCustomerGroupResponse, ApiException> prepareRetrieveCustomerGroupRequest(String groupId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/groups/{group_id}").templateParam(param -> param.key("group_id").value((Object)groupId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveCustomerGroupResponse)ApiHelper.deserialize((String)response, RetrieveCustomerGroupResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateCustomerGroupResponse updateCustomerGroup(String groupId, UpdateCustomerGroupRequest body) throws ApiException, IOException {
        return (UpdateCustomerGroupResponse)this.prepareUpdateCustomerGroupRequest(groupId, body).execute();
    }

    @Override
    public CompletableFuture<UpdateCustomerGroupResponse> updateCustomerGroupAsync(String groupId, UpdateCustomerGroupRequest body) {
        try {
            return this.prepareUpdateCustomerGroupRequest(groupId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateCustomerGroupResponse, ApiException> prepareUpdateCustomerGroupRequest(String groupId, UpdateCustomerGroupRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/customers/groups/{group_id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("group_id").value((Object)groupId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateCustomerGroupResponse)ApiHelper.deserialize((String)response, UpdateCustomerGroupResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

