/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.GiftCardActivitiesApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.CreateGiftCardActivityRequest;
import com.squareup.square.models.CreateGiftCardActivityResponse;
import com.squareup.square.models.ListGiftCardActivitiesResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultGiftCardActivitiesApi
extends BaseApi
implements GiftCardActivitiesApi {
    public DefaultGiftCardActivitiesApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListGiftCardActivitiesResponse listGiftCardActivities(String giftCardId, String type, String locationId, String beginTime, String endTime, Integer limit, String cursor, String sortOrder) throws ApiException, IOException {
        return (ListGiftCardActivitiesResponse)this.prepareListGiftCardActivitiesRequest(giftCardId, type, locationId, beginTime, endTime, limit, cursor, sortOrder).execute();
    }

    @Override
    public CompletableFuture<ListGiftCardActivitiesResponse> listGiftCardActivitiesAsync(String giftCardId, String type, String locationId, String beginTime, String endTime, Integer limit, String cursor, String sortOrder) {
        try {
            return this.prepareListGiftCardActivitiesRequest(giftCardId, type, locationId, beginTime, endTime, limit, cursor, sortOrder).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListGiftCardActivitiesResponse, ApiException> prepareListGiftCardActivitiesRequest(String giftCardId, String type, String locationId, String beginTime, String endTime, Integer limit, String cursor, String sortOrder) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/gift-cards/activities").queryParam(param -> param.key("gift_card_id").value((Object)giftCardId).isRequired(false)).queryParam(param -> param.key("type").value((Object)type).isRequired(false)).queryParam(param -> param.key("location_id").value((Object)locationId).isRequired(false)).queryParam(param -> param.key("begin_time").value((Object)beginTime).isRequired(false)).queryParam(param -> param.key("end_time").value((Object)endTime).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("sort_order").value((Object)sortOrder).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListGiftCardActivitiesResponse)ApiHelper.deserialize((String)response, ListGiftCardActivitiesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateGiftCardActivityResponse createGiftCardActivity(CreateGiftCardActivityRequest body) throws ApiException, IOException {
        return (CreateGiftCardActivityResponse)this.prepareCreateGiftCardActivityRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateGiftCardActivityResponse> createGiftCardActivityAsync(CreateGiftCardActivityRequest body) {
        try {
            return this.prepareCreateGiftCardActivityRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateGiftCardActivityResponse, ApiException> prepareCreateGiftCardActivityRequest(CreateGiftCardActivityRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/gift-cards/activities").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateGiftCardActivityResponse)ApiHelper.deserialize((String)response, CreateGiftCardActivityResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

