/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.LaborApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.CreateBreakTypeRequest;
import com.squareup.square.models.CreateBreakTypeResponse;
import com.squareup.square.models.CreateShiftRequest;
import com.squareup.square.models.CreateShiftResponse;
import com.squareup.square.models.DeleteBreakTypeResponse;
import com.squareup.square.models.DeleteShiftResponse;
import com.squareup.square.models.GetBreakTypeResponse;
import com.squareup.square.models.GetEmployeeWageResponse;
import com.squareup.square.models.GetShiftResponse;
import com.squareup.square.models.GetTeamMemberWageResponse;
import com.squareup.square.models.ListBreakTypesResponse;
import com.squareup.square.models.ListEmployeeWagesResponse;
import com.squareup.square.models.ListTeamMemberWagesResponse;
import com.squareup.square.models.ListWorkweekConfigsResponse;
import com.squareup.square.models.SearchShiftsRequest;
import com.squareup.square.models.SearchShiftsResponse;
import com.squareup.square.models.UpdateBreakTypeRequest;
import com.squareup.square.models.UpdateBreakTypeResponse;
import com.squareup.square.models.UpdateShiftRequest;
import com.squareup.square.models.UpdateShiftResponse;
import com.squareup.square.models.UpdateWorkweekConfigRequest;
import com.squareup.square.models.UpdateWorkweekConfigResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultLaborApi
extends BaseApi
implements LaborApi {
    public DefaultLaborApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListBreakTypesResponse listBreakTypes(String locationId, Integer limit, String cursor) throws ApiException, IOException {
        return (ListBreakTypesResponse)this.prepareListBreakTypesRequest(locationId, limit, cursor).execute();
    }

    @Override
    public CompletableFuture<ListBreakTypesResponse> listBreakTypesAsync(String locationId, Integer limit, String cursor) {
        try {
            return this.prepareListBreakTypesRequest(locationId, limit, cursor).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListBreakTypesResponse, ApiException> prepareListBreakTypesRequest(String locationId, Integer limit, String cursor) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/break-types").queryParam(param -> param.key("location_id").value((Object)locationId).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListBreakTypesResponse)ApiHelper.deserialize((String)response, ListBreakTypesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateBreakTypeResponse createBreakType(CreateBreakTypeRequest body) throws ApiException, IOException {
        return (CreateBreakTypeResponse)this.prepareCreateBreakTypeRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateBreakTypeResponse> createBreakTypeAsync(CreateBreakTypeRequest body) {
        try {
            return this.prepareCreateBreakTypeRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateBreakTypeResponse, ApiException> prepareCreateBreakTypeRequest(CreateBreakTypeRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/break-types").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateBreakTypeResponse)ApiHelper.deserialize((String)response, CreateBreakTypeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteBreakTypeResponse deleteBreakType(String id) throws ApiException, IOException {
        return (DeleteBreakTypeResponse)this.prepareDeleteBreakTypeRequest(id).execute();
    }

    @Override
    public CompletableFuture<DeleteBreakTypeResponse> deleteBreakTypeAsync(String id) {
        try {
            return this.prepareDeleteBreakTypeRequest(id).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteBreakTypeResponse, ApiException> prepareDeleteBreakTypeRequest(String id) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/break-types/{id}").templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteBreakTypeResponse)ApiHelper.deserialize((String)response, DeleteBreakTypeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetBreakTypeResponse getBreakType(String id) throws ApiException, IOException {
        return (GetBreakTypeResponse)this.prepareGetBreakTypeRequest(id).execute();
    }

    @Override
    public CompletableFuture<GetBreakTypeResponse> getBreakTypeAsync(String id) {
        try {
            return this.prepareGetBreakTypeRequest(id).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetBreakTypeResponse, ApiException> prepareGetBreakTypeRequest(String id) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/break-types/{id}").templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetBreakTypeResponse)ApiHelper.deserialize((String)response, GetBreakTypeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateBreakTypeResponse updateBreakType(String id, UpdateBreakTypeRequest body) throws ApiException, IOException {
        return (UpdateBreakTypeResponse)this.prepareUpdateBreakTypeRequest(id, body).execute();
    }

    @Override
    public CompletableFuture<UpdateBreakTypeResponse> updateBreakTypeAsync(String id, UpdateBreakTypeRequest body) {
        try {
            return this.prepareUpdateBreakTypeRequest(id, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateBreakTypeResponse, ApiException> prepareUpdateBreakTypeRequest(String id, UpdateBreakTypeRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/break-types/{id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateBreakTypeResponse)ApiHelper.deserialize((String)response, UpdateBreakTypeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    @Deprecated
    public ListEmployeeWagesResponse listEmployeeWages(String employeeId, Integer limit, String cursor) throws ApiException, IOException {
        return (ListEmployeeWagesResponse)this.prepareListEmployeeWagesRequest(employeeId, limit, cursor).execute();
    }

    @Override
    @Deprecated
    public CompletableFuture<ListEmployeeWagesResponse> listEmployeeWagesAsync(String employeeId, Integer limit, String cursor) {
        try {
            return this.prepareListEmployeeWagesRequest(employeeId, limit, cursor).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListEmployeeWagesResponse, ApiException> prepareListEmployeeWagesRequest(String employeeId, Integer limit, String cursor) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/employee-wages").queryParam(param -> param.key("employee_id").value((Object)employeeId).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListEmployeeWagesResponse)ApiHelper.deserialize((String)response, ListEmployeeWagesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    @Deprecated
    public GetEmployeeWageResponse getEmployeeWage(String id) throws ApiException, IOException {
        return (GetEmployeeWageResponse)this.prepareGetEmployeeWageRequest(id).execute();
    }

    @Override
    @Deprecated
    public CompletableFuture<GetEmployeeWageResponse> getEmployeeWageAsync(String id) {
        try {
            return this.prepareGetEmployeeWageRequest(id).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetEmployeeWageResponse, ApiException> prepareGetEmployeeWageRequest(String id) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/employee-wages/{id}").templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetEmployeeWageResponse)ApiHelper.deserialize((String)response, GetEmployeeWageResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateShiftResponse createShift(CreateShiftRequest body) throws ApiException, IOException {
        return (CreateShiftResponse)this.prepareCreateShiftRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateShiftResponse> createShiftAsync(CreateShiftRequest body) {
        try {
            return this.prepareCreateShiftRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateShiftResponse, ApiException> prepareCreateShiftRequest(CreateShiftRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/shifts").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateShiftResponse)ApiHelper.deserialize((String)response, CreateShiftResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchShiftsResponse searchShifts(SearchShiftsRequest body) throws ApiException, IOException {
        return (SearchShiftsResponse)this.prepareSearchShiftsRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchShiftsResponse> searchShiftsAsync(SearchShiftsRequest body) {
        try {
            return this.prepareSearchShiftsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchShiftsResponse, ApiException> prepareSearchShiftsRequest(SearchShiftsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/shifts/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchShiftsResponse)ApiHelper.deserialize((String)response, SearchShiftsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteShiftResponse deleteShift(String id) throws ApiException, IOException {
        return (DeleteShiftResponse)this.prepareDeleteShiftRequest(id).execute();
    }

    @Override
    public CompletableFuture<DeleteShiftResponse> deleteShiftAsync(String id) {
        try {
            return this.prepareDeleteShiftRequest(id).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteShiftResponse, ApiException> prepareDeleteShiftRequest(String id) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/shifts/{id}").templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteShiftResponse)ApiHelper.deserialize((String)response, DeleteShiftResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetShiftResponse getShift(String id) throws ApiException, IOException {
        return (GetShiftResponse)this.prepareGetShiftRequest(id).execute();
    }

    @Override
    public CompletableFuture<GetShiftResponse> getShiftAsync(String id) {
        try {
            return this.prepareGetShiftRequest(id).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetShiftResponse, ApiException> prepareGetShiftRequest(String id) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/shifts/{id}").templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetShiftResponse)ApiHelper.deserialize((String)response, GetShiftResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateShiftResponse updateShift(String id, UpdateShiftRequest body) throws ApiException, IOException {
        return (UpdateShiftResponse)this.prepareUpdateShiftRequest(id, body).execute();
    }

    @Override
    public CompletableFuture<UpdateShiftResponse> updateShiftAsync(String id, UpdateShiftRequest body) {
        try {
            return this.prepareUpdateShiftRequest(id, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateShiftResponse, ApiException> prepareUpdateShiftRequest(String id, UpdateShiftRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/shifts/{id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateShiftResponse)ApiHelper.deserialize((String)response, UpdateShiftResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListTeamMemberWagesResponse listTeamMemberWages(String teamMemberId, Integer limit, String cursor) throws ApiException, IOException {
        return (ListTeamMemberWagesResponse)this.prepareListTeamMemberWagesRequest(teamMemberId, limit, cursor).execute();
    }

    @Override
    public CompletableFuture<ListTeamMemberWagesResponse> listTeamMemberWagesAsync(String teamMemberId, Integer limit, String cursor) {
        try {
            return this.prepareListTeamMemberWagesRequest(teamMemberId, limit, cursor).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListTeamMemberWagesResponse, ApiException> prepareListTeamMemberWagesRequest(String teamMemberId, Integer limit, String cursor) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/team-member-wages").queryParam(param -> param.key("team_member_id").value((Object)teamMemberId).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListTeamMemberWagesResponse)ApiHelper.deserialize((String)response, ListTeamMemberWagesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetTeamMemberWageResponse getTeamMemberWage(String id) throws ApiException, IOException {
        return (GetTeamMemberWageResponse)this.prepareGetTeamMemberWageRequest(id).execute();
    }

    @Override
    public CompletableFuture<GetTeamMemberWageResponse> getTeamMemberWageAsync(String id) {
        try {
            return this.prepareGetTeamMemberWageRequest(id).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetTeamMemberWageResponse, ApiException> prepareGetTeamMemberWageRequest(String id) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/team-member-wages/{id}").templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetTeamMemberWageResponse)ApiHelper.deserialize((String)response, GetTeamMemberWageResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListWorkweekConfigsResponse listWorkweekConfigs(Integer limit, String cursor) throws ApiException, IOException {
        return (ListWorkweekConfigsResponse)this.prepareListWorkweekConfigsRequest(limit, cursor).execute();
    }

    @Override
    public CompletableFuture<ListWorkweekConfigsResponse> listWorkweekConfigsAsync(Integer limit, String cursor) {
        try {
            return this.prepareListWorkweekConfigsRequest(limit, cursor).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListWorkweekConfigsResponse, ApiException> prepareListWorkweekConfigsRequest(Integer limit, String cursor) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/workweek-configs").queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListWorkweekConfigsResponse)ApiHelper.deserialize((String)response, ListWorkweekConfigsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateWorkweekConfigResponse updateWorkweekConfig(String id, UpdateWorkweekConfigRequest body) throws ApiException, IOException {
        return (UpdateWorkweekConfigResponse)this.prepareUpdateWorkweekConfigRequest(id, body).execute();
    }

    @Override
    public CompletableFuture<UpdateWorkweekConfigResponse> updateWorkweekConfigAsync(String id, UpdateWorkweekConfigRequest body) {
        try {
            return this.prepareUpdateWorkweekConfigRequest(id, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateWorkweekConfigResponse, ApiException> prepareUpdateWorkweekConfigRequest(String id, UpdateWorkweekConfigRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/labor/workweek-configs/{id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("id").value((Object)id).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateWorkweekConfigResponse)ApiHelper.deserialize((String)response, UpdateWorkweekConfigResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

