/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.LocationCustomAttributesApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.BulkDeleteLocationCustomAttributesRequest;
import com.squareup.square.models.BulkDeleteLocationCustomAttributesResponse;
import com.squareup.square.models.BulkUpsertLocationCustomAttributesRequest;
import com.squareup.square.models.BulkUpsertLocationCustomAttributesResponse;
import com.squareup.square.models.CreateLocationCustomAttributeDefinitionRequest;
import com.squareup.square.models.CreateLocationCustomAttributeDefinitionResponse;
import com.squareup.square.models.DeleteLocationCustomAttributeDefinitionResponse;
import com.squareup.square.models.DeleteLocationCustomAttributeResponse;
import com.squareup.square.models.ListLocationCustomAttributeDefinitionsResponse;
import com.squareup.square.models.ListLocationCustomAttributesResponse;
import com.squareup.square.models.RetrieveLocationCustomAttributeDefinitionResponse;
import com.squareup.square.models.RetrieveLocationCustomAttributeResponse;
import com.squareup.square.models.UpdateLocationCustomAttributeDefinitionRequest;
import com.squareup.square.models.UpdateLocationCustomAttributeDefinitionResponse;
import com.squareup.square.models.UpsertLocationCustomAttributeRequest;
import com.squareup.square.models.UpsertLocationCustomAttributeResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultLocationCustomAttributesApi
extends BaseApi
implements LocationCustomAttributesApi {
    public DefaultLocationCustomAttributesApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListLocationCustomAttributeDefinitionsResponse listLocationCustomAttributeDefinitions(String visibilityFilter, Integer limit, String cursor) throws ApiException, IOException {
        return (ListLocationCustomAttributeDefinitionsResponse)this.prepareListLocationCustomAttributeDefinitionsRequest(visibilityFilter, limit, cursor).execute();
    }

    @Override
    public CompletableFuture<ListLocationCustomAttributeDefinitionsResponse> listLocationCustomAttributeDefinitionsAsync(String visibilityFilter, Integer limit, String cursor) {
        try {
            return this.prepareListLocationCustomAttributeDefinitionsRequest(visibilityFilter, limit, cursor).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListLocationCustomAttributeDefinitionsResponse, ApiException> prepareListLocationCustomAttributeDefinitionsRequest(String visibilityFilter, Integer limit, String cursor) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations/custom-attribute-definitions").queryParam(param -> param.key("visibility_filter").value((Object)visibilityFilter).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListLocationCustomAttributeDefinitionsResponse)ApiHelper.deserialize((String)response, ListLocationCustomAttributeDefinitionsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateLocationCustomAttributeDefinitionResponse createLocationCustomAttributeDefinition(CreateLocationCustomAttributeDefinitionRequest body) throws ApiException, IOException {
        return (CreateLocationCustomAttributeDefinitionResponse)this.prepareCreateLocationCustomAttributeDefinitionRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateLocationCustomAttributeDefinitionResponse> createLocationCustomAttributeDefinitionAsync(CreateLocationCustomAttributeDefinitionRequest body) {
        try {
            return this.prepareCreateLocationCustomAttributeDefinitionRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateLocationCustomAttributeDefinitionResponse, ApiException> prepareCreateLocationCustomAttributeDefinitionRequest(CreateLocationCustomAttributeDefinitionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations/custom-attribute-definitions").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateLocationCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, CreateLocationCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteLocationCustomAttributeDefinitionResponse deleteLocationCustomAttributeDefinition(String key) throws ApiException, IOException {
        return (DeleteLocationCustomAttributeDefinitionResponse)this.prepareDeleteLocationCustomAttributeDefinitionRequest(key).execute();
    }

    @Override
    public CompletableFuture<DeleteLocationCustomAttributeDefinitionResponse> deleteLocationCustomAttributeDefinitionAsync(String key) {
        try {
            return this.prepareDeleteLocationCustomAttributeDefinitionRequest(key).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteLocationCustomAttributeDefinitionResponse, ApiException> prepareDeleteLocationCustomAttributeDefinitionRequest(String key) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations/custom-attribute-definitions/{key}").templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteLocationCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, DeleteLocationCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveLocationCustomAttributeDefinitionResponse retrieveLocationCustomAttributeDefinition(String key, Integer version) throws ApiException, IOException {
        return (RetrieveLocationCustomAttributeDefinitionResponse)this.prepareRetrieveLocationCustomAttributeDefinitionRequest(key, version).execute();
    }

    @Override
    public CompletableFuture<RetrieveLocationCustomAttributeDefinitionResponse> retrieveLocationCustomAttributeDefinitionAsync(String key, Integer version) {
        try {
            return this.prepareRetrieveLocationCustomAttributeDefinitionRequest(key, version).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveLocationCustomAttributeDefinitionResponse, ApiException> prepareRetrieveLocationCustomAttributeDefinitionRequest(String key, Integer version) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations/custom-attribute-definitions/{key}").queryParam(param -> param.key("version").value((Object)version).isRequired(false)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveLocationCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, RetrieveLocationCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateLocationCustomAttributeDefinitionResponse updateLocationCustomAttributeDefinition(String key, UpdateLocationCustomAttributeDefinitionRequest body) throws ApiException, IOException {
        return (UpdateLocationCustomAttributeDefinitionResponse)this.prepareUpdateLocationCustomAttributeDefinitionRequest(key, body).execute();
    }

    @Override
    public CompletableFuture<UpdateLocationCustomAttributeDefinitionResponse> updateLocationCustomAttributeDefinitionAsync(String key, UpdateLocationCustomAttributeDefinitionRequest body) {
        try {
            return this.prepareUpdateLocationCustomAttributeDefinitionRequest(key, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateLocationCustomAttributeDefinitionResponse, ApiException> prepareUpdateLocationCustomAttributeDefinitionRequest(String key, UpdateLocationCustomAttributeDefinitionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations/custom-attribute-definitions/{key}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateLocationCustomAttributeDefinitionResponse)ApiHelper.deserialize((String)response, UpdateLocationCustomAttributeDefinitionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkDeleteLocationCustomAttributesResponse bulkDeleteLocationCustomAttributes(BulkDeleteLocationCustomAttributesRequest body) throws ApiException, IOException {
        return (BulkDeleteLocationCustomAttributesResponse)this.prepareBulkDeleteLocationCustomAttributesRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkDeleteLocationCustomAttributesResponse> bulkDeleteLocationCustomAttributesAsync(BulkDeleteLocationCustomAttributesRequest body) {
        try {
            return this.prepareBulkDeleteLocationCustomAttributesRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkDeleteLocationCustomAttributesResponse, ApiException> prepareBulkDeleteLocationCustomAttributesRequest(BulkDeleteLocationCustomAttributesRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations/custom-attributes/bulk-delete").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkDeleteLocationCustomAttributesResponse)ApiHelper.deserialize((String)response, BulkDeleteLocationCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkUpsertLocationCustomAttributesResponse bulkUpsertLocationCustomAttributes(BulkUpsertLocationCustomAttributesRequest body) throws ApiException, IOException {
        return (BulkUpsertLocationCustomAttributesResponse)this.prepareBulkUpsertLocationCustomAttributesRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkUpsertLocationCustomAttributesResponse> bulkUpsertLocationCustomAttributesAsync(BulkUpsertLocationCustomAttributesRequest body) {
        try {
            return this.prepareBulkUpsertLocationCustomAttributesRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkUpsertLocationCustomAttributesResponse, ApiException> prepareBulkUpsertLocationCustomAttributesRequest(BulkUpsertLocationCustomAttributesRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations/custom-attributes/bulk-upsert").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkUpsertLocationCustomAttributesResponse)ApiHelper.deserialize((String)response, BulkUpsertLocationCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListLocationCustomAttributesResponse listLocationCustomAttributes(String locationId, String visibilityFilter, Integer limit, String cursor, Boolean withDefinitions) throws ApiException, IOException {
        return (ListLocationCustomAttributesResponse)this.prepareListLocationCustomAttributesRequest(locationId, visibilityFilter, limit, cursor, withDefinitions).execute();
    }

    @Override
    public CompletableFuture<ListLocationCustomAttributesResponse> listLocationCustomAttributesAsync(String locationId, String visibilityFilter, Integer limit, String cursor, Boolean withDefinitions) {
        try {
            return this.prepareListLocationCustomAttributesRequest(locationId, visibilityFilter, limit, cursor, withDefinitions).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListLocationCustomAttributesResponse, ApiException> prepareListLocationCustomAttributesRequest(String locationId, String visibilityFilter, Integer limit, String cursor, Boolean withDefinitions) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations/{location_id}/custom-attributes").queryParam(param -> param.key("visibility_filter").value((Object)visibilityFilter).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("with_definitions").value((Object)(withDefinitions != null ? withDefinitions : false)).isRequired(false)).templateParam(param -> param.key("location_id").value((Object)locationId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListLocationCustomAttributesResponse)ApiHelper.deserialize((String)response, ListLocationCustomAttributesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteLocationCustomAttributeResponse deleteLocationCustomAttribute(String locationId, String key) throws ApiException, IOException {
        return (DeleteLocationCustomAttributeResponse)this.prepareDeleteLocationCustomAttributeRequest(locationId, key).execute();
    }

    @Override
    public CompletableFuture<DeleteLocationCustomAttributeResponse> deleteLocationCustomAttributeAsync(String locationId, String key) {
        try {
            return this.prepareDeleteLocationCustomAttributeRequest(locationId, key).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteLocationCustomAttributeResponse, ApiException> prepareDeleteLocationCustomAttributeRequest(String locationId, String key) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations/{location_id}/custom-attributes/{key}").templateParam(param -> param.key("location_id").value((Object)locationId).shouldEncode(true)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteLocationCustomAttributeResponse)ApiHelper.deserialize((String)response, DeleteLocationCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveLocationCustomAttributeResponse retrieveLocationCustomAttribute(String locationId, String key, Boolean withDefinition, Integer version) throws ApiException, IOException {
        return (RetrieveLocationCustomAttributeResponse)this.prepareRetrieveLocationCustomAttributeRequest(locationId, key, withDefinition, version).execute();
    }

    @Override
    public CompletableFuture<RetrieveLocationCustomAttributeResponse> retrieveLocationCustomAttributeAsync(String locationId, String key, Boolean withDefinition, Integer version) {
        try {
            return this.prepareRetrieveLocationCustomAttributeRequest(locationId, key, withDefinition, version).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveLocationCustomAttributeResponse, ApiException> prepareRetrieveLocationCustomAttributeRequest(String locationId, String key, Boolean withDefinition, Integer version) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations/{location_id}/custom-attributes/{key}").queryParam(param -> param.key("with_definition").value((Object)(withDefinition != null ? withDefinition : false)).isRequired(false)).queryParam(param -> param.key("version").value((Object)version).isRequired(false)).templateParam(param -> param.key("location_id").value((Object)locationId).shouldEncode(true)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveLocationCustomAttributeResponse)ApiHelper.deserialize((String)response, RetrieveLocationCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpsertLocationCustomAttributeResponse upsertLocationCustomAttribute(String locationId, String key, UpsertLocationCustomAttributeRequest body) throws ApiException, IOException {
        return (UpsertLocationCustomAttributeResponse)this.prepareUpsertLocationCustomAttributeRequest(locationId, key, body).execute();
    }

    @Override
    public CompletableFuture<UpsertLocationCustomAttributeResponse> upsertLocationCustomAttributeAsync(String locationId, String key, UpsertLocationCustomAttributeRequest body) {
        try {
            return this.prepareUpsertLocationCustomAttributeRequest(locationId, key, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpsertLocationCustomAttributeResponse, ApiException> prepareUpsertLocationCustomAttributeRequest(String locationId, String key, UpsertLocationCustomAttributeRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations/{location_id}/custom-attributes/{key}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("location_id").value((Object)locationId).shouldEncode(true)).templateParam(param -> param.key("key").value((Object)key).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpsertLocationCustomAttributeResponse)ApiHelper.deserialize((String)response, UpsertLocationCustomAttributeResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

