/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.LocationsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.CreateLocationRequest;
import com.squareup.square.models.CreateLocationResponse;
import com.squareup.square.models.ListLocationsResponse;
import com.squareup.square.models.RetrieveLocationResponse;
import com.squareup.square.models.UpdateLocationRequest;
import com.squareup.square.models.UpdateLocationResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultLocationsApi
extends BaseApi
implements LocationsApi {
    public DefaultLocationsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListLocationsResponse listLocations() throws ApiException, IOException {
        return (ListLocationsResponse)this.prepareListLocationsRequest().execute();
    }

    @Override
    public CompletableFuture<ListLocationsResponse> listLocationsAsync() {
        try {
            return this.prepareListLocationsRequest().executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListLocationsResponse, ApiException> prepareListLocationsRequest() throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations").headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListLocationsResponse)ApiHelper.deserialize((String)response, ListLocationsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateLocationResponse createLocation(CreateLocationRequest body) throws ApiException, IOException {
        return (CreateLocationResponse)this.prepareCreateLocationRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateLocationResponse> createLocationAsync(CreateLocationRequest body) {
        try {
            return this.prepareCreateLocationRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateLocationResponse, ApiException> prepareCreateLocationRequest(CreateLocationRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateLocationResponse)ApiHelper.deserialize((String)response, CreateLocationResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveLocationResponse retrieveLocation(String locationId) throws ApiException, IOException {
        return (RetrieveLocationResponse)this.prepareRetrieveLocationRequest(locationId).execute();
    }

    @Override
    public CompletableFuture<RetrieveLocationResponse> retrieveLocationAsync(String locationId) {
        try {
            return this.prepareRetrieveLocationRequest(locationId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveLocationResponse, ApiException> prepareRetrieveLocationRequest(String locationId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations/{location_id}").templateParam(param -> param.key("location_id").value((Object)locationId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveLocationResponse)ApiHelper.deserialize((String)response, RetrieveLocationResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateLocationResponse updateLocation(String locationId, UpdateLocationRequest body) throws ApiException, IOException {
        return (UpdateLocationResponse)this.prepareUpdateLocationRequest(locationId, body).execute();
    }

    @Override
    public CompletableFuture<UpdateLocationResponse> updateLocationAsync(String locationId, UpdateLocationRequest body) {
        try {
            return this.prepareUpdateLocationRequest(locationId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateLocationResponse, ApiException> prepareUpdateLocationRequest(String locationId, UpdateLocationRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/locations/{location_id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("location_id").value((Object)locationId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateLocationResponse)ApiHelper.deserialize((String)response, UpdateLocationResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

