/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.LoyaltyApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.AccumulateLoyaltyPointsRequest;
import com.squareup.square.models.AccumulateLoyaltyPointsResponse;
import com.squareup.square.models.AdjustLoyaltyPointsRequest;
import com.squareup.square.models.AdjustLoyaltyPointsResponse;
import com.squareup.square.models.CalculateLoyaltyPointsRequest;
import com.squareup.square.models.CalculateLoyaltyPointsResponse;
import com.squareup.square.models.CancelLoyaltyPromotionResponse;
import com.squareup.square.models.CreateLoyaltyAccountRequest;
import com.squareup.square.models.CreateLoyaltyAccountResponse;
import com.squareup.square.models.CreateLoyaltyPromotionRequest;
import com.squareup.square.models.CreateLoyaltyPromotionResponse;
import com.squareup.square.models.CreateLoyaltyRewardRequest;
import com.squareup.square.models.CreateLoyaltyRewardResponse;
import com.squareup.square.models.DeleteLoyaltyRewardResponse;
import com.squareup.square.models.ListLoyaltyProgramsResponse;
import com.squareup.square.models.ListLoyaltyPromotionsResponse;
import com.squareup.square.models.RedeemLoyaltyRewardRequest;
import com.squareup.square.models.RedeemLoyaltyRewardResponse;
import com.squareup.square.models.RetrieveLoyaltyAccountResponse;
import com.squareup.square.models.RetrieveLoyaltyProgramResponse;
import com.squareup.square.models.RetrieveLoyaltyPromotionResponse;
import com.squareup.square.models.RetrieveLoyaltyRewardResponse;
import com.squareup.square.models.SearchLoyaltyAccountsRequest;
import com.squareup.square.models.SearchLoyaltyAccountsResponse;
import com.squareup.square.models.SearchLoyaltyEventsRequest;
import com.squareup.square.models.SearchLoyaltyEventsResponse;
import com.squareup.square.models.SearchLoyaltyRewardsRequest;
import com.squareup.square.models.SearchLoyaltyRewardsResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultLoyaltyApi
extends BaseApi
implements LoyaltyApi {
    public DefaultLoyaltyApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public CreateLoyaltyAccountResponse createLoyaltyAccount(CreateLoyaltyAccountRequest body) throws ApiException, IOException {
        return (CreateLoyaltyAccountResponse)this.prepareCreateLoyaltyAccountRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateLoyaltyAccountResponse> createLoyaltyAccountAsync(CreateLoyaltyAccountRequest body) {
        try {
            return this.prepareCreateLoyaltyAccountRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateLoyaltyAccountResponse, ApiException> prepareCreateLoyaltyAccountRequest(CreateLoyaltyAccountRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/accounts").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateLoyaltyAccountResponse)ApiHelper.deserialize((String)response, CreateLoyaltyAccountResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchLoyaltyAccountsResponse searchLoyaltyAccounts(SearchLoyaltyAccountsRequest body) throws ApiException, IOException {
        return (SearchLoyaltyAccountsResponse)this.prepareSearchLoyaltyAccountsRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchLoyaltyAccountsResponse> searchLoyaltyAccountsAsync(SearchLoyaltyAccountsRequest body) {
        try {
            return this.prepareSearchLoyaltyAccountsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchLoyaltyAccountsResponse, ApiException> prepareSearchLoyaltyAccountsRequest(SearchLoyaltyAccountsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/accounts/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchLoyaltyAccountsResponse)ApiHelper.deserialize((String)response, SearchLoyaltyAccountsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveLoyaltyAccountResponse retrieveLoyaltyAccount(String accountId) throws ApiException, IOException {
        return (RetrieveLoyaltyAccountResponse)this.prepareRetrieveLoyaltyAccountRequest(accountId).execute();
    }

    @Override
    public CompletableFuture<RetrieveLoyaltyAccountResponse> retrieveLoyaltyAccountAsync(String accountId) {
        try {
            return this.prepareRetrieveLoyaltyAccountRequest(accountId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveLoyaltyAccountResponse, ApiException> prepareRetrieveLoyaltyAccountRequest(String accountId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/accounts/{account_id}").templateParam(param -> param.key("account_id").value((Object)accountId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveLoyaltyAccountResponse)ApiHelper.deserialize((String)response, RetrieveLoyaltyAccountResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public AccumulateLoyaltyPointsResponse accumulateLoyaltyPoints(String accountId, AccumulateLoyaltyPointsRequest body) throws ApiException, IOException {
        return (AccumulateLoyaltyPointsResponse)this.prepareAccumulateLoyaltyPointsRequest(accountId, body).execute();
    }

    @Override
    public CompletableFuture<AccumulateLoyaltyPointsResponse> accumulateLoyaltyPointsAsync(String accountId, AccumulateLoyaltyPointsRequest body) {
        try {
            return this.prepareAccumulateLoyaltyPointsRequest(accountId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<AccumulateLoyaltyPointsResponse, ApiException> prepareAccumulateLoyaltyPointsRequest(String accountId, AccumulateLoyaltyPointsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/accounts/{account_id}/accumulate").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("account_id").value((Object)accountId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (AccumulateLoyaltyPointsResponse)ApiHelper.deserialize((String)response, AccumulateLoyaltyPointsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public AdjustLoyaltyPointsResponse adjustLoyaltyPoints(String accountId, AdjustLoyaltyPointsRequest body) throws ApiException, IOException {
        return (AdjustLoyaltyPointsResponse)this.prepareAdjustLoyaltyPointsRequest(accountId, body).execute();
    }

    @Override
    public CompletableFuture<AdjustLoyaltyPointsResponse> adjustLoyaltyPointsAsync(String accountId, AdjustLoyaltyPointsRequest body) {
        try {
            return this.prepareAdjustLoyaltyPointsRequest(accountId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<AdjustLoyaltyPointsResponse, ApiException> prepareAdjustLoyaltyPointsRequest(String accountId, AdjustLoyaltyPointsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/accounts/{account_id}/adjust").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("account_id").value((Object)accountId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (AdjustLoyaltyPointsResponse)ApiHelper.deserialize((String)response, AdjustLoyaltyPointsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchLoyaltyEventsResponse searchLoyaltyEvents(SearchLoyaltyEventsRequest body) throws ApiException, IOException {
        return (SearchLoyaltyEventsResponse)this.prepareSearchLoyaltyEventsRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchLoyaltyEventsResponse> searchLoyaltyEventsAsync(SearchLoyaltyEventsRequest body) {
        try {
            return this.prepareSearchLoyaltyEventsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchLoyaltyEventsResponse, ApiException> prepareSearchLoyaltyEventsRequest(SearchLoyaltyEventsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/events/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchLoyaltyEventsResponse)ApiHelper.deserialize((String)response, SearchLoyaltyEventsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    @Deprecated
    public ListLoyaltyProgramsResponse listLoyaltyPrograms() throws ApiException, IOException {
        return (ListLoyaltyProgramsResponse)this.prepareListLoyaltyProgramsRequest().execute();
    }

    @Override
    @Deprecated
    public CompletableFuture<ListLoyaltyProgramsResponse> listLoyaltyProgramsAsync() {
        try {
            return this.prepareListLoyaltyProgramsRequest().executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListLoyaltyProgramsResponse, ApiException> prepareListLoyaltyProgramsRequest() throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/programs").headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListLoyaltyProgramsResponse)ApiHelper.deserialize((String)response, ListLoyaltyProgramsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveLoyaltyProgramResponse retrieveLoyaltyProgram(String programId) throws ApiException, IOException {
        return (RetrieveLoyaltyProgramResponse)this.prepareRetrieveLoyaltyProgramRequest(programId).execute();
    }

    @Override
    public CompletableFuture<RetrieveLoyaltyProgramResponse> retrieveLoyaltyProgramAsync(String programId) {
        try {
            return this.prepareRetrieveLoyaltyProgramRequest(programId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveLoyaltyProgramResponse, ApiException> prepareRetrieveLoyaltyProgramRequest(String programId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/programs/{program_id}").templateParam(param -> param.key("program_id").value((Object)programId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveLoyaltyProgramResponse)ApiHelper.deserialize((String)response, RetrieveLoyaltyProgramResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CalculateLoyaltyPointsResponse calculateLoyaltyPoints(String programId, CalculateLoyaltyPointsRequest body) throws ApiException, IOException {
        return (CalculateLoyaltyPointsResponse)this.prepareCalculateLoyaltyPointsRequest(programId, body).execute();
    }

    @Override
    public CompletableFuture<CalculateLoyaltyPointsResponse> calculateLoyaltyPointsAsync(String programId, CalculateLoyaltyPointsRequest body) {
        try {
            return this.prepareCalculateLoyaltyPointsRequest(programId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CalculateLoyaltyPointsResponse, ApiException> prepareCalculateLoyaltyPointsRequest(String programId, CalculateLoyaltyPointsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/programs/{program_id}/calculate").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("program_id").value((Object)programId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CalculateLoyaltyPointsResponse)ApiHelper.deserialize((String)response, CalculateLoyaltyPointsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListLoyaltyPromotionsResponse listLoyaltyPromotions(String programId, String status, String cursor, Integer limit) throws ApiException, IOException {
        return (ListLoyaltyPromotionsResponse)this.prepareListLoyaltyPromotionsRequest(programId, status, cursor, limit).execute();
    }

    @Override
    public CompletableFuture<ListLoyaltyPromotionsResponse> listLoyaltyPromotionsAsync(String programId, String status, String cursor, Integer limit) {
        try {
            return this.prepareListLoyaltyPromotionsRequest(programId, status, cursor, limit).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListLoyaltyPromotionsResponse, ApiException> prepareListLoyaltyPromotionsRequest(String programId, String status, String cursor, Integer limit) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/programs/{program_id}/promotions").queryParam(param -> param.key("status").value((Object)status).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).templateParam(param -> param.key("program_id").value((Object)programId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListLoyaltyPromotionsResponse)ApiHelper.deserialize((String)response, ListLoyaltyPromotionsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateLoyaltyPromotionResponse createLoyaltyPromotion(String programId, CreateLoyaltyPromotionRequest body) throws ApiException, IOException {
        return (CreateLoyaltyPromotionResponse)this.prepareCreateLoyaltyPromotionRequest(programId, body).execute();
    }

    @Override
    public CompletableFuture<CreateLoyaltyPromotionResponse> createLoyaltyPromotionAsync(String programId, CreateLoyaltyPromotionRequest body) {
        try {
            return this.prepareCreateLoyaltyPromotionRequest(programId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateLoyaltyPromotionResponse, ApiException> prepareCreateLoyaltyPromotionRequest(String programId, CreateLoyaltyPromotionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/programs/{program_id}/promotions").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("program_id").value((Object)programId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateLoyaltyPromotionResponse)ApiHelper.deserialize((String)response, CreateLoyaltyPromotionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveLoyaltyPromotionResponse retrieveLoyaltyPromotion(String promotionId, String programId) throws ApiException, IOException {
        return (RetrieveLoyaltyPromotionResponse)this.prepareRetrieveLoyaltyPromotionRequest(promotionId, programId).execute();
    }

    @Override
    public CompletableFuture<RetrieveLoyaltyPromotionResponse> retrieveLoyaltyPromotionAsync(String promotionId, String programId) {
        try {
            return this.prepareRetrieveLoyaltyPromotionRequest(promotionId, programId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveLoyaltyPromotionResponse, ApiException> prepareRetrieveLoyaltyPromotionRequest(String promotionId, String programId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/programs/{program_id}/promotions/{promotion_id}").templateParam(param -> param.key("promotion_id").value((Object)promotionId).shouldEncode(true)).templateParam(param -> param.key("program_id").value((Object)programId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveLoyaltyPromotionResponse)ApiHelper.deserialize((String)response, RetrieveLoyaltyPromotionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CancelLoyaltyPromotionResponse cancelLoyaltyPromotion(String promotionId, String programId) throws ApiException, IOException {
        return (CancelLoyaltyPromotionResponse)this.prepareCancelLoyaltyPromotionRequest(promotionId, programId).execute();
    }

    @Override
    public CompletableFuture<CancelLoyaltyPromotionResponse> cancelLoyaltyPromotionAsync(String promotionId, String programId) {
        try {
            return this.prepareCancelLoyaltyPromotionRequest(promotionId, programId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CancelLoyaltyPromotionResponse, ApiException> prepareCancelLoyaltyPromotionRequest(String promotionId, String programId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/programs/{program_id}/promotions/{promotion_id}/cancel").templateParam(param -> param.key("promotion_id").value((Object)promotionId).shouldEncode(true)).templateParam(param -> param.key("program_id").value((Object)programId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CancelLoyaltyPromotionResponse)ApiHelper.deserialize((String)response, CancelLoyaltyPromotionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateLoyaltyRewardResponse createLoyaltyReward(CreateLoyaltyRewardRequest body) throws ApiException, IOException {
        return (CreateLoyaltyRewardResponse)this.prepareCreateLoyaltyRewardRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateLoyaltyRewardResponse> createLoyaltyRewardAsync(CreateLoyaltyRewardRequest body) {
        try {
            return this.prepareCreateLoyaltyRewardRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateLoyaltyRewardResponse, ApiException> prepareCreateLoyaltyRewardRequest(CreateLoyaltyRewardRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/rewards").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateLoyaltyRewardResponse)ApiHelper.deserialize((String)response, CreateLoyaltyRewardResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchLoyaltyRewardsResponse searchLoyaltyRewards(SearchLoyaltyRewardsRequest body) throws ApiException, IOException {
        return (SearchLoyaltyRewardsResponse)this.prepareSearchLoyaltyRewardsRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchLoyaltyRewardsResponse> searchLoyaltyRewardsAsync(SearchLoyaltyRewardsRequest body) {
        try {
            return this.prepareSearchLoyaltyRewardsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchLoyaltyRewardsResponse, ApiException> prepareSearchLoyaltyRewardsRequest(SearchLoyaltyRewardsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/rewards/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchLoyaltyRewardsResponse)ApiHelper.deserialize((String)response, SearchLoyaltyRewardsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteLoyaltyRewardResponse deleteLoyaltyReward(String rewardId) throws ApiException, IOException {
        return (DeleteLoyaltyRewardResponse)this.prepareDeleteLoyaltyRewardRequest(rewardId).execute();
    }

    @Override
    public CompletableFuture<DeleteLoyaltyRewardResponse> deleteLoyaltyRewardAsync(String rewardId) {
        try {
            return this.prepareDeleteLoyaltyRewardRequest(rewardId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteLoyaltyRewardResponse, ApiException> prepareDeleteLoyaltyRewardRequest(String rewardId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/rewards/{reward_id}").templateParam(param -> param.key("reward_id").value((Object)rewardId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteLoyaltyRewardResponse)ApiHelper.deserialize((String)response, DeleteLoyaltyRewardResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveLoyaltyRewardResponse retrieveLoyaltyReward(String rewardId) throws ApiException, IOException {
        return (RetrieveLoyaltyRewardResponse)this.prepareRetrieveLoyaltyRewardRequest(rewardId).execute();
    }

    @Override
    public CompletableFuture<RetrieveLoyaltyRewardResponse> retrieveLoyaltyRewardAsync(String rewardId) {
        try {
            return this.prepareRetrieveLoyaltyRewardRequest(rewardId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveLoyaltyRewardResponse, ApiException> prepareRetrieveLoyaltyRewardRequest(String rewardId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/rewards/{reward_id}").templateParam(param -> param.key("reward_id").value((Object)rewardId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveLoyaltyRewardResponse)ApiHelper.deserialize((String)response, RetrieveLoyaltyRewardResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RedeemLoyaltyRewardResponse redeemLoyaltyReward(String rewardId, RedeemLoyaltyRewardRequest body) throws ApiException, IOException {
        return (RedeemLoyaltyRewardResponse)this.prepareRedeemLoyaltyRewardRequest(rewardId, body).execute();
    }

    @Override
    public CompletableFuture<RedeemLoyaltyRewardResponse> redeemLoyaltyRewardAsync(String rewardId, RedeemLoyaltyRewardRequest body) {
        try {
            return this.prepareRedeemLoyaltyRewardRequest(rewardId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RedeemLoyaltyRewardResponse, ApiException> prepareRedeemLoyaltyRewardRequest(String rewardId, RedeemLoyaltyRewardRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/loyalty/rewards/{reward_id}/redeem").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("reward_id").value((Object)rewardId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RedeemLoyaltyRewardResponse)ApiHelper.deserialize((String)response, RedeemLoyaltyRewardResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

