/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.PaymentsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.CancelPaymentByIdempotencyKeyRequest;
import com.squareup.square.models.CancelPaymentByIdempotencyKeyResponse;
import com.squareup.square.models.CancelPaymentResponse;
import com.squareup.square.models.CompletePaymentRequest;
import com.squareup.square.models.CompletePaymentResponse;
import com.squareup.square.models.CreatePaymentRequest;
import com.squareup.square.models.CreatePaymentResponse;
import com.squareup.square.models.GetPaymentResponse;
import com.squareup.square.models.ListPaymentsResponse;
import com.squareup.square.models.UpdatePaymentRequest;
import com.squareup.square.models.UpdatePaymentResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultPaymentsApi
extends BaseApi
implements PaymentsApi {
    public DefaultPaymentsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListPaymentsResponse listPayments(String beginTime, String endTime, String sortOrder, String cursor, String locationId, Long total, String last4, String cardBrand, Integer limit) throws ApiException, IOException {
        return (ListPaymentsResponse)this.prepareListPaymentsRequest(beginTime, endTime, sortOrder, cursor, locationId, total, last4, cardBrand, limit).execute();
    }

    @Override
    public CompletableFuture<ListPaymentsResponse> listPaymentsAsync(String beginTime, String endTime, String sortOrder, String cursor, String locationId, Long total, String last4, String cardBrand, Integer limit) {
        try {
            return this.prepareListPaymentsRequest(beginTime, endTime, sortOrder, cursor, locationId, total, last4, cardBrand, limit).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListPaymentsResponse, ApiException> prepareListPaymentsRequest(String beginTime, String endTime, String sortOrder, String cursor, String locationId, Long total, String last4, String cardBrand, Integer limit) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments").queryParam(param -> param.key("begin_time").value((Object)beginTime).isRequired(false)).queryParam(param -> param.key("end_time").value((Object)endTime).isRequired(false)).queryParam(param -> param.key("sort_order").value((Object)sortOrder).isRequired(false)).queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("location_id").value((Object)locationId).isRequired(false)).queryParam(param -> param.key("total").value((Object)total).isRequired(false)).queryParam(param -> param.key("last_4").value((Object)last4).isRequired(false)).queryParam(param -> param.key("card_brand").value((Object)cardBrand).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListPaymentsResponse)ApiHelper.deserialize((String)response, ListPaymentsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreatePaymentResponse createPayment(CreatePaymentRequest body) throws ApiException, IOException {
        return (CreatePaymentResponse)this.prepareCreatePaymentRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreatePaymentResponse> createPaymentAsync(CreatePaymentRequest body) {
        try {
            return this.prepareCreatePaymentRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreatePaymentResponse, ApiException> prepareCreatePaymentRequest(CreatePaymentRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreatePaymentResponse)ApiHelper.deserialize((String)response, CreatePaymentResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CancelPaymentByIdempotencyKeyResponse cancelPaymentByIdempotencyKey(CancelPaymentByIdempotencyKeyRequest body) throws ApiException, IOException {
        return (CancelPaymentByIdempotencyKeyResponse)this.prepareCancelPaymentByIdempotencyKeyRequest(body).execute();
    }

    @Override
    public CompletableFuture<CancelPaymentByIdempotencyKeyResponse> cancelPaymentByIdempotencyKeyAsync(CancelPaymentByIdempotencyKeyRequest body) {
        try {
            return this.prepareCancelPaymentByIdempotencyKeyRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CancelPaymentByIdempotencyKeyResponse, ApiException> prepareCancelPaymentByIdempotencyKeyRequest(CancelPaymentByIdempotencyKeyRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/cancel").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CancelPaymentByIdempotencyKeyResponse)ApiHelper.deserialize((String)response, CancelPaymentByIdempotencyKeyResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public GetPaymentResponse getPayment(String paymentId) throws ApiException, IOException {
        return (GetPaymentResponse)this.prepareGetPaymentRequest(paymentId).execute();
    }

    @Override
    public CompletableFuture<GetPaymentResponse> getPaymentAsync(String paymentId) {
        try {
            return this.prepareGetPaymentRequest(paymentId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<GetPaymentResponse, ApiException> prepareGetPaymentRequest(String paymentId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/{payment_id}").templateParam(param -> param.key("payment_id").value((Object)paymentId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (GetPaymentResponse)ApiHelper.deserialize((String)response, GetPaymentResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdatePaymentResponse updatePayment(String paymentId, UpdatePaymentRequest body) throws ApiException, IOException {
        return (UpdatePaymentResponse)this.prepareUpdatePaymentRequest(paymentId, body).execute();
    }

    @Override
    public CompletableFuture<UpdatePaymentResponse> updatePaymentAsync(String paymentId, UpdatePaymentRequest body) {
        try {
            return this.prepareUpdatePaymentRequest(paymentId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdatePaymentResponse, ApiException> prepareUpdatePaymentRequest(String paymentId, UpdatePaymentRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/{payment_id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("payment_id").value((Object)paymentId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdatePaymentResponse)ApiHelper.deserialize((String)response, UpdatePaymentResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CancelPaymentResponse cancelPayment(String paymentId) throws ApiException, IOException {
        return (CancelPaymentResponse)this.prepareCancelPaymentRequest(paymentId).execute();
    }

    @Override
    public CompletableFuture<CancelPaymentResponse> cancelPaymentAsync(String paymentId) {
        try {
            return this.prepareCancelPaymentRequest(paymentId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CancelPaymentResponse, ApiException> prepareCancelPaymentRequest(String paymentId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/{payment_id}/cancel").templateParam(param -> param.key("payment_id").value((Object)paymentId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CancelPaymentResponse)ApiHelper.deserialize((String)response, CancelPaymentResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CompletePaymentResponse completePayment(String paymentId, CompletePaymentRequest body) throws ApiException, IOException {
        return (CompletePaymentResponse)this.prepareCompletePaymentRequest(paymentId, body).execute();
    }

    @Override
    public CompletableFuture<CompletePaymentResponse> completePaymentAsync(String paymentId, CompletePaymentRequest body) {
        try {
            return this.prepareCompletePaymentRequest(paymentId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CompletePaymentResponse, ApiException> prepareCompletePaymentRequest(String paymentId, CompletePaymentRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/payments/{payment_id}/complete").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("payment_id").value((Object)paymentId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CompletePaymentResponse)ApiHelper.deserialize((String)response, CompletePaymentResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

