/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.VendorsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.BulkCreateVendorsRequest;
import com.squareup.square.models.BulkCreateVendorsResponse;
import com.squareup.square.models.BulkRetrieveVendorsRequest;
import com.squareup.square.models.BulkRetrieveVendorsResponse;
import com.squareup.square.models.BulkUpdateVendorsRequest;
import com.squareup.square.models.BulkUpdateVendorsResponse;
import com.squareup.square.models.CreateVendorRequest;
import com.squareup.square.models.CreateVendorResponse;
import com.squareup.square.models.RetrieveVendorResponse;
import com.squareup.square.models.SearchVendorsRequest;
import com.squareup.square.models.SearchVendorsResponse;
import com.squareup.square.models.UpdateVendorRequest;
import com.squareup.square.models.UpdateVendorResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultVendorsApi
extends BaseApi
implements VendorsApi {
    public DefaultVendorsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public BulkCreateVendorsResponse bulkCreateVendors(BulkCreateVendorsRequest body) throws ApiException, IOException {
        return (BulkCreateVendorsResponse)this.prepareBulkCreateVendorsRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkCreateVendorsResponse> bulkCreateVendorsAsync(BulkCreateVendorsRequest body) {
        try {
            return this.prepareBulkCreateVendorsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkCreateVendorsResponse, ApiException> prepareBulkCreateVendorsRequest(BulkCreateVendorsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/vendors/bulk-create").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkCreateVendorsResponse)ApiHelper.deserialize((String)response, BulkCreateVendorsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkRetrieveVendorsResponse bulkRetrieveVendors(BulkRetrieveVendorsRequest body) throws ApiException, IOException {
        return (BulkRetrieveVendorsResponse)this.prepareBulkRetrieveVendorsRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkRetrieveVendorsResponse> bulkRetrieveVendorsAsync(BulkRetrieveVendorsRequest body) {
        try {
            return this.prepareBulkRetrieveVendorsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkRetrieveVendorsResponse, ApiException> prepareBulkRetrieveVendorsRequest(BulkRetrieveVendorsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/vendors/bulk-retrieve").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkRetrieveVendorsResponse)ApiHelper.deserialize((String)response, BulkRetrieveVendorsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public BulkUpdateVendorsResponse bulkUpdateVendors(BulkUpdateVendorsRequest body) throws ApiException, IOException {
        return (BulkUpdateVendorsResponse)this.prepareBulkUpdateVendorsRequest(body).execute();
    }

    @Override
    public CompletableFuture<BulkUpdateVendorsResponse> bulkUpdateVendorsAsync(BulkUpdateVendorsRequest body) {
        try {
            return this.prepareBulkUpdateVendorsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<BulkUpdateVendorsResponse, ApiException> prepareBulkUpdateVendorsRequest(BulkUpdateVendorsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/vendors/bulk-update").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (BulkUpdateVendorsResponse)ApiHelper.deserialize((String)response, BulkUpdateVendorsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateVendorResponse createVendor(CreateVendorRequest body) throws ApiException, IOException {
        return (CreateVendorResponse)this.prepareCreateVendorRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateVendorResponse> createVendorAsync(CreateVendorRequest body) {
        try {
            return this.prepareCreateVendorRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateVendorResponse, ApiException> prepareCreateVendorRequest(CreateVendorRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/vendors/create").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateVendorResponse)ApiHelper.deserialize((String)response, CreateVendorResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public SearchVendorsResponse searchVendors(SearchVendorsRequest body) throws ApiException, IOException {
        return (SearchVendorsResponse)this.prepareSearchVendorsRequest(body).execute();
    }

    @Override
    public CompletableFuture<SearchVendorsResponse> searchVendorsAsync(SearchVendorsRequest body) {
        try {
            return this.prepareSearchVendorsRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<SearchVendorsResponse, ApiException> prepareSearchVendorsRequest(SearchVendorsRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/vendors/search").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (SearchVendorsResponse)ApiHelper.deserialize((String)response, SearchVendorsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveVendorResponse retrieveVendor(String vendorId) throws ApiException, IOException {
        return (RetrieveVendorResponse)this.prepareRetrieveVendorRequest(vendorId).execute();
    }

    @Override
    public CompletableFuture<RetrieveVendorResponse> retrieveVendorAsync(String vendorId) {
        try {
            return this.prepareRetrieveVendorRequest(vendorId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveVendorResponse, ApiException> prepareRetrieveVendorRequest(String vendorId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/vendors/{vendor_id}").templateParam(param -> param.key("vendor_id").value((Object)vendorId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveVendorResponse)ApiHelper.deserialize((String)response, RetrieveVendorResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateVendorResponse updateVendor(UpdateVendorRequest body, String vendorId) throws ApiException, IOException {
        return (UpdateVendorResponse)this.prepareUpdateVendorRequest(body, vendorId).execute();
    }

    @Override
    public CompletableFuture<UpdateVendorResponse> updateVendorAsync(UpdateVendorRequest body, String vendorId) {
        try {
            return this.prepareUpdateVendorRequest(body, vendorId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateVendorResponse, ApiException> prepareUpdateVendorRequest(UpdateVendorRequest body, String vendorId) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/vendors/{vendor_id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("vendor_id").value((Object)vendorId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateVendorResponse)ApiHelper.deserialize((String)response, UpdateVendorResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

