/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.ApiHelper;
import com.squareup.square.Server;
import com.squareup.square.api.BaseApi;
import com.squareup.square.api.WebhookSubscriptionsApi;
import com.squareup.square.exceptions.ApiException;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.http.request.HttpMethod;
import com.squareup.square.models.CreateWebhookSubscriptionRequest;
import com.squareup.square.models.CreateWebhookSubscriptionResponse;
import com.squareup.square.models.DeleteWebhookSubscriptionResponse;
import com.squareup.square.models.ListWebhookEventTypesResponse;
import com.squareup.square.models.ListWebhookSubscriptionsResponse;
import com.squareup.square.models.RetrieveWebhookSubscriptionResponse;
import com.squareup.square.models.TestWebhookSubscriptionRequest;
import com.squareup.square.models.TestWebhookSubscriptionResponse;
import com.squareup.square.models.UpdateWebhookSubscriptionRequest;
import com.squareup.square.models.UpdateWebhookSubscriptionResponse;
import com.squareup.square.models.UpdateWebhookSubscriptionSignatureKeyRequest;
import com.squareup.square.models.UpdateWebhookSubscriptionSignatureKeyResponse;
import io.apimatic.core.ApiCall;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class DefaultWebhookSubscriptionsApi
extends BaseApi
implements WebhookSubscriptionsApi {
    public DefaultWebhookSubscriptionsApi(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    @Override
    public ListWebhookEventTypesResponse listWebhookEventTypes(String apiVersion) throws ApiException, IOException {
        return (ListWebhookEventTypesResponse)this.prepareListWebhookEventTypesRequest(apiVersion).execute();
    }

    @Override
    public CompletableFuture<ListWebhookEventTypesResponse> listWebhookEventTypesAsync(String apiVersion) {
        try {
            return this.prepareListWebhookEventTypesRequest(apiVersion).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListWebhookEventTypesResponse, ApiException> prepareListWebhookEventTypesRequest(String apiVersion) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/webhooks/event-types").queryParam(param -> param.key("api_version").value((Object)apiVersion).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListWebhookEventTypesResponse)ApiHelper.deserialize((String)response, ListWebhookEventTypesResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public ListWebhookSubscriptionsResponse listWebhookSubscriptions(String cursor, Boolean includeDisabled, String sortOrder, Integer limit) throws ApiException, IOException {
        return (ListWebhookSubscriptionsResponse)this.prepareListWebhookSubscriptionsRequest(cursor, includeDisabled, sortOrder, limit).execute();
    }

    @Override
    public CompletableFuture<ListWebhookSubscriptionsResponse> listWebhookSubscriptionsAsync(String cursor, Boolean includeDisabled, String sortOrder, Integer limit) {
        try {
            return this.prepareListWebhookSubscriptionsRequest(cursor, includeDisabled, sortOrder, limit).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ListWebhookSubscriptionsResponse, ApiException> prepareListWebhookSubscriptionsRequest(String cursor, Boolean includeDisabled, String sortOrder, Integer limit) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/webhooks/subscriptions").queryParam(param -> param.key("cursor").value((Object)cursor).isRequired(false)).queryParam(param -> param.key("include_disabled").value((Object)(includeDisabled != null ? includeDisabled : false)).isRequired(false)).queryParam(param -> param.key("sort_order").value((Object)sortOrder).isRequired(false)).queryParam(param -> param.key("limit").value((Object)limit).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (ListWebhookSubscriptionsResponse)ApiHelper.deserialize((String)response, ListWebhookSubscriptionsResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public CreateWebhookSubscriptionResponse createWebhookSubscription(CreateWebhookSubscriptionRequest body) throws ApiException, IOException {
        return (CreateWebhookSubscriptionResponse)this.prepareCreateWebhookSubscriptionRequest(body).execute();
    }

    @Override
    public CompletableFuture<CreateWebhookSubscriptionResponse> createWebhookSubscriptionAsync(CreateWebhookSubscriptionRequest body) {
        try {
            return this.prepareCreateWebhookSubscriptionRequest(body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<CreateWebhookSubscriptionResponse, ApiException> prepareCreateWebhookSubscriptionRequest(CreateWebhookSubscriptionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/webhooks/subscriptions").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (CreateWebhookSubscriptionResponse)ApiHelper.deserialize((String)response, CreateWebhookSubscriptionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public DeleteWebhookSubscriptionResponse deleteWebhookSubscription(String subscriptionId) throws ApiException, IOException {
        return (DeleteWebhookSubscriptionResponse)this.prepareDeleteWebhookSubscriptionRequest(subscriptionId).execute();
    }

    @Override
    public CompletableFuture<DeleteWebhookSubscriptionResponse> deleteWebhookSubscriptionAsync(String subscriptionId) {
        try {
            return this.prepareDeleteWebhookSubscriptionRequest(subscriptionId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<DeleteWebhookSubscriptionResponse, ApiException> prepareDeleteWebhookSubscriptionRequest(String subscriptionId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/webhooks/subscriptions/{subscription_id}").templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.DELETE)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (DeleteWebhookSubscriptionResponse)ApiHelper.deserialize((String)response, DeleteWebhookSubscriptionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public RetrieveWebhookSubscriptionResponse retrieveWebhookSubscription(String subscriptionId) throws ApiException, IOException {
        return (RetrieveWebhookSubscriptionResponse)this.prepareRetrieveWebhookSubscriptionRequest(subscriptionId).execute();
    }

    @Override
    public CompletableFuture<RetrieveWebhookSubscriptionResponse> retrieveWebhookSubscriptionAsync(String subscriptionId) {
        try {
            return this.prepareRetrieveWebhookSubscriptionRequest(subscriptionId).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<RetrieveWebhookSubscriptionResponse, ApiException> prepareRetrieveWebhookSubscriptionRequest(String subscriptionId) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/webhooks/subscriptions/{subscription_id}").templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (RetrieveWebhookSubscriptionResponse)ApiHelper.deserialize((String)response, RetrieveWebhookSubscriptionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateWebhookSubscriptionResponse updateWebhookSubscription(String subscriptionId, UpdateWebhookSubscriptionRequest body) throws ApiException, IOException {
        return (UpdateWebhookSubscriptionResponse)this.prepareUpdateWebhookSubscriptionRequest(subscriptionId, body).execute();
    }

    @Override
    public CompletableFuture<UpdateWebhookSubscriptionResponse> updateWebhookSubscriptionAsync(String subscriptionId, UpdateWebhookSubscriptionRequest body) {
        try {
            return this.prepareUpdateWebhookSubscriptionRequest(subscriptionId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateWebhookSubscriptionResponse, ApiException> prepareUpdateWebhookSubscriptionRequest(String subscriptionId, UpdateWebhookSubscriptionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/webhooks/subscriptions/{subscription_id}").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.PUT)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateWebhookSubscriptionResponse)ApiHelper.deserialize((String)response, UpdateWebhookSubscriptionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public UpdateWebhookSubscriptionSignatureKeyResponse updateWebhookSubscriptionSignatureKey(String subscriptionId, UpdateWebhookSubscriptionSignatureKeyRequest body) throws ApiException, IOException {
        return (UpdateWebhookSubscriptionSignatureKeyResponse)this.prepareUpdateWebhookSubscriptionSignatureKeyRequest(subscriptionId, body).execute();
    }

    @Override
    public CompletableFuture<UpdateWebhookSubscriptionSignatureKeyResponse> updateWebhookSubscriptionSignatureKeyAsync(String subscriptionId, UpdateWebhookSubscriptionSignatureKeyRequest body) {
        try {
            return this.prepareUpdateWebhookSubscriptionSignatureKeyRequest(subscriptionId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<UpdateWebhookSubscriptionSignatureKeyResponse, ApiException> prepareUpdateWebhookSubscriptionSignatureKeyRequest(String subscriptionId, UpdateWebhookSubscriptionSignatureKeyRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/webhooks/subscriptions/{subscription_id}/signature-key").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (UpdateWebhookSubscriptionSignatureKeyResponse)ApiHelper.deserialize((String)response, UpdateWebhookSubscriptionSignatureKeyResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    @Override
    public TestWebhookSubscriptionResponse testWebhookSubscription(String subscriptionId, TestWebhookSubscriptionRequest body) throws ApiException, IOException {
        return (TestWebhookSubscriptionResponse)this.prepareTestWebhookSubscriptionRequest(subscriptionId, body).execute();
    }

    @Override
    public CompletableFuture<TestWebhookSubscriptionResponse> testWebhookSubscriptionAsync(String subscriptionId, TestWebhookSubscriptionRequest body) {
        try {
            return this.prepareTestWebhookSubscriptionRequest(subscriptionId, body).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<TestWebhookSubscriptionResponse, ApiException> prepareTestWebhookSubscriptionRequest(String subscriptionId, TestWebhookSubscriptionRequest body) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/webhooks/subscriptions/{subscription_id}/test").bodyParam(param -> param.value((Object)body)).bodySerializer(() -> ApiHelper.serialize((Object)body)).templateParam(param -> param.key("subscription_id").value((Object)subscriptionId).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).authenticationKey("global").httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.deserializer(response -> (TestWebhookSubscriptionResponse)ApiHelper.deserialize((String)response, TestWebhookSubscriptionResponse.class)).nullify404(false).contextInitializer((context, result) -> result.toBuilder().httpContext((HttpContext)context).build()).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

