/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.http.request;

import com.squareup.square.ApiHelper;
import com.squareup.square.http.Headers;
import com.squareup.square.http.request.HttpMethod;
import io.apimatic.coreinterfaces.http.request.ArraySerializationFormat;
import io.apimatic.coreinterfaces.http.request.Request;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpRequest
implements Request {
    private HttpMethod httpMethod;
    private Headers headers;
    private StringBuilder queryUrlBuilder;
    private List<AbstractMap.SimpleEntry<String, Object>> parameters;
    private Map<String, Object> queryParameters;
    private Object body;

    public HttpRequest(HttpMethod method, StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParameters, List<AbstractMap.SimpleEntry<String, Object>> parameters) {
        this.httpMethod = method;
        this.queryUrlBuilder = queryUrlBuilder;
        this.headers = headers;
        this.queryParameters = queryParameters;
        this.parameters = parameters;
    }

    public HttpRequest(HttpMethod method, StringBuilder queryUrlBuilder, Headers headers, Map<String, Object> queryParameters, Object body) {
        this(method, queryUrlBuilder, headers, queryParameters, null);
        this.body = body != null ? body : "";
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public String getQueryUrl() {
        return this.queryUrlBuilder.toString();
    }

    public List<AbstractMap.SimpleEntry<String, Object>> getParameters() {
        return this.parameters;
    }

    public Map<String, Object> getQueryParameters() {
        return this.queryParameters;
    }

    public Object getBody() {
        return this.body;
    }

    public void addQueryParameter(String key, Object value) {
        if (key == null || key.isEmpty() || value == null) {
            return;
        }
        if (this.queryParameters == null) {
            this.queryParameters = new HashMap<String, Object>();
        }
        this.queryParameters.put(key, value);
    }

    public String toString() {
        return "HttpRequest [httpMethod=" + (Object)((Object)this.httpMethod) + ", headers=" + this.headers + ", queryUrlBuilder=" + this.queryUrlBuilder + ", queryParameters=" + this.queryParameters + ", parameters=" + this.parameters + "]";
    }

    public String getUrl(ArraySerializationFormat arraySerializationFormat) {
        StringBuilder urlBuilder = new StringBuilder(this.getQueryUrl());
        ApiHelper.appendUrlWithQueryParameters((StringBuilder)urlBuilder, this.getQueryParameters(), (ArraySerializationFormat)arraySerializationFormat);
        return ApiHelper.cleanUrl((StringBuilder)urlBuilder);
    }
}

