/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class AppointmentSegment {
    private final OptionalNullable<Integer> durationMinutes;
    private final OptionalNullable<String> serviceVariationId;
    private final String teamMemberId;
    private final OptionalNullable<Long> serviceVariationVersion;
    private final Integer intermissionMinutes;
    private final Boolean anyTeamMember;
    private final List<String> resourceIds;

    @JsonCreator
    public AppointmentSegment(@JsonProperty(value="team_member_id") String teamMemberId, @JsonProperty(value="duration_minutes") Integer durationMinutes, @JsonProperty(value="service_variation_id") String serviceVariationId, @JsonProperty(value="service_variation_version") Long serviceVariationVersion, @JsonProperty(value="intermission_minutes") Integer intermissionMinutes, @JsonProperty(value="any_team_member") Boolean anyTeamMember, @JsonProperty(value="resource_ids") List<String> resourceIds) {
        this.durationMinutes = OptionalNullable.of((Object)durationMinutes);
        this.serviceVariationId = OptionalNullable.of((Object)serviceVariationId);
        this.teamMemberId = teamMemberId;
        this.serviceVariationVersion = OptionalNullable.of((Object)serviceVariationVersion);
        this.intermissionMinutes = intermissionMinutes;
        this.anyTeamMember = anyTeamMember;
        this.resourceIds = resourceIds;
    }

    protected AppointmentSegment(String teamMemberId, OptionalNullable<Integer> durationMinutes, OptionalNullable<String> serviceVariationId, OptionalNullable<Long> serviceVariationVersion, Integer intermissionMinutes, Boolean anyTeamMember, List<String> resourceIds) {
        this.durationMinutes = durationMinutes;
        this.serviceVariationId = serviceVariationId;
        this.teamMemberId = teamMemberId;
        this.serviceVariationVersion = serviceVariationVersion;
        this.intermissionMinutes = intermissionMinutes;
        this.anyTeamMember = anyTeamMember;
        this.resourceIds = resourceIds;
    }

    @JsonGetter(value="duration_minutes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Integer> internalGetDurationMinutes() {
        return this.durationMinutes;
    }

    @JsonIgnore
    public Integer getDurationMinutes() {
        return (Integer)OptionalNullable.getFrom(this.durationMinutes);
    }

    @JsonGetter(value="service_variation_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetServiceVariationId() {
        return this.serviceVariationId;
    }

    @JsonIgnore
    public String getServiceVariationId() {
        return (String)OptionalNullable.getFrom(this.serviceVariationId);
    }

    @JsonGetter(value="team_member_id")
    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    @JsonGetter(value="service_variation_version")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<Long> internalGetServiceVariationVersion() {
        return this.serviceVariationVersion;
    }

    @JsonIgnore
    public Long getServiceVariationVersion() {
        return (Long)OptionalNullable.getFrom(this.serviceVariationVersion);
    }

    @JsonGetter(value="intermission_minutes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getIntermissionMinutes() {
        return this.intermissionMinutes;
    }

    @JsonGetter(value="any_team_member")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getAnyTeamMember() {
        return this.anyTeamMember;
    }

    @JsonGetter(value="resource_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    public int hashCode() {
        return Objects.hash(this.durationMinutes, this.serviceVariationId, this.teamMemberId, this.serviceVariationVersion, this.intermissionMinutes, this.anyTeamMember, this.resourceIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AppointmentSegment)) {
            return false;
        }
        AppointmentSegment other = (AppointmentSegment)obj;
        return Objects.equals(this.durationMinutes, other.durationMinutes) && Objects.equals(this.serviceVariationId, other.serviceVariationId) && Objects.equals(this.teamMemberId, other.teamMemberId) && Objects.equals(this.serviceVariationVersion, other.serviceVariationVersion) && Objects.equals(this.intermissionMinutes, other.intermissionMinutes) && Objects.equals(this.anyTeamMember, other.anyTeamMember) && Objects.equals(this.resourceIds, other.resourceIds);
    }

    public String toString() {
        return "AppointmentSegment [teamMemberId=" + this.teamMemberId + ", durationMinutes=" + this.durationMinutes + ", serviceVariationId=" + this.serviceVariationId + ", serviceVariationVersion=" + this.serviceVariationVersion + ", intermissionMinutes=" + this.intermissionMinutes + ", anyTeamMember=" + this.anyTeamMember + ", resourceIds=" + this.resourceIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.teamMemberId).intermissionMinutes(this.getIntermissionMinutes()).anyTeamMember(this.getAnyTeamMember()).resourceIds(this.getResourceIds());
        builder.durationMinutes = this.internalGetDurationMinutes();
        builder.serviceVariationId = this.internalGetServiceVariationId();
        builder.serviceVariationVersion = this.internalGetServiceVariationVersion();
        return builder;
    }

    public static class Builder {
        private String teamMemberId;
        private OptionalNullable<Integer> durationMinutes;
        private OptionalNullable<String> serviceVariationId;
        private OptionalNullable<Long> serviceVariationVersion;
        private Integer intermissionMinutes;
        private Boolean anyTeamMember;
        private List<String> resourceIds;

        public Builder(String teamMemberId) {
            this.teamMemberId = teamMemberId;
        }

        public Builder teamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public Builder durationMinutes(Integer durationMinutes) {
            this.durationMinutes = OptionalNullable.of((Object)durationMinutes);
            return this;
        }

        public Builder unsetDurationMinutes() {
            this.durationMinutes = null;
            return this;
        }

        public Builder serviceVariationId(String serviceVariationId) {
            this.serviceVariationId = OptionalNullable.of((Object)serviceVariationId);
            return this;
        }

        public Builder unsetServiceVariationId() {
            this.serviceVariationId = null;
            return this;
        }

        public Builder serviceVariationVersion(Long serviceVariationVersion) {
            this.serviceVariationVersion = OptionalNullable.of((Object)serviceVariationVersion);
            return this;
        }

        public Builder unsetServiceVariationVersion() {
            this.serviceVariationVersion = null;
            return this;
        }

        public Builder intermissionMinutes(Integer intermissionMinutes) {
            this.intermissionMinutes = intermissionMinutes;
            return this;
        }

        public Builder anyTeamMember(Boolean anyTeamMember) {
            this.anyTeamMember = anyTeamMember;
            return this;
        }

        public Builder resourceIds(List<String> resourceIds) {
            this.resourceIds = resourceIds;
            return this;
        }

        public AppointmentSegment build() {
            return new AppointmentSegment(this.teamMemberId, this.durationMinutes, this.serviceVariationId, this.serviceVariationVersion, this.intermissionMinutes, this.anyTeamMember, this.resourceIds);
        }
    }
}

