/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.ACHDetails;
import com.squareup.square.models.Error;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class BankAccountPaymentDetails {
    private final OptionalNullable<String> bankName;
    private final OptionalNullable<String> transferType;
    private final OptionalNullable<String> accountOwnershipType;
    private final OptionalNullable<String> fingerprint;
    private final OptionalNullable<String> country;
    private final OptionalNullable<String> statementDescription;
    private final ACHDetails achDetails;
    private final OptionalNullable<List<Error>> errors;

    @JsonCreator
    public BankAccountPaymentDetails(@JsonProperty(value="bank_name") String bankName, @JsonProperty(value="transfer_type") String transferType, @JsonProperty(value="account_ownership_type") String accountOwnershipType, @JsonProperty(value="fingerprint") String fingerprint, @JsonProperty(value="country") String country, @JsonProperty(value="statement_description") String statementDescription, @JsonProperty(value="ach_details") ACHDetails achDetails, @JsonProperty(value="errors") List<Error> errors) {
        this.bankName = OptionalNullable.of((Object)bankName);
        this.transferType = OptionalNullable.of((Object)transferType);
        this.accountOwnershipType = OptionalNullable.of((Object)accountOwnershipType);
        this.fingerprint = OptionalNullable.of((Object)fingerprint);
        this.country = OptionalNullable.of((Object)country);
        this.statementDescription = OptionalNullable.of((Object)statementDescription);
        this.achDetails = achDetails;
        this.errors = OptionalNullable.of(errors);
    }

    protected BankAccountPaymentDetails(OptionalNullable<String> bankName, OptionalNullable<String> transferType, OptionalNullable<String> accountOwnershipType, OptionalNullable<String> fingerprint, OptionalNullable<String> country, OptionalNullable<String> statementDescription, ACHDetails achDetails, OptionalNullable<List<Error>> errors) {
        this.bankName = bankName;
        this.transferType = transferType;
        this.accountOwnershipType = accountOwnershipType;
        this.fingerprint = fingerprint;
        this.country = country;
        this.statementDescription = statementDescription;
        this.achDetails = achDetails;
        this.errors = errors;
    }

    @JsonGetter(value="bank_name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBankName() {
        return this.bankName;
    }

    @JsonIgnore
    public String getBankName() {
        return (String)OptionalNullable.getFrom(this.bankName);
    }

    @JsonGetter(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetTransferType() {
        return this.transferType;
    }

    @JsonIgnore
    public String getTransferType() {
        return (String)OptionalNullable.getFrom(this.transferType);
    }

    @JsonGetter(value="account_ownership_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetAccountOwnershipType() {
        return this.accountOwnershipType;
    }

    @JsonIgnore
    public String getAccountOwnershipType() {
        return (String)OptionalNullable.getFrom(this.accountOwnershipType);
    }

    @JsonGetter(value="fingerprint")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetFingerprint() {
        return this.fingerprint;
    }

    @JsonIgnore
    public String getFingerprint() {
        return (String)OptionalNullable.getFrom(this.fingerprint);
    }

    @JsonGetter(value="country")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetCountry() {
        return this.country;
    }

    @JsonIgnore
    public String getCountry() {
        return (String)OptionalNullable.getFrom(this.country);
    }

    @JsonGetter(value="statement_description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetStatementDescription() {
        return this.statementDescription;
    }

    @JsonIgnore
    public String getStatementDescription() {
        return (String)OptionalNullable.getFrom(this.statementDescription);
    }

    @JsonGetter(value="ach_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ACHDetails getAchDetails() {
        return this.achDetails;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<Error>> internalGetErrors() {
        return this.errors;
    }

    @JsonIgnore
    public List<Error> getErrors() {
        return (List)OptionalNullable.getFrom(this.errors);
    }

    public int hashCode() {
        return Objects.hash(this.bankName, this.transferType, this.accountOwnershipType, this.fingerprint, this.country, this.statementDescription, this.achDetails, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BankAccountPaymentDetails)) {
            return false;
        }
        BankAccountPaymentDetails other = (BankAccountPaymentDetails)obj;
        return Objects.equals(this.bankName, other.bankName) && Objects.equals(this.transferType, other.transferType) && Objects.equals(this.accountOwnershipType, other.accountOwnershipType) && Objects.equals(this.fingerprint, other.fingerprint) && Objects.equals(this.country, other.country) && Objects.equals(this.statementDescription, other.statementDescription) && Objects.equals(this.achDetails, other.achDetails) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "BankAccountPaymentDetails [bankName=" + this.bankName + ", transferType=" + this.transferType + ", accountOwnershipType=" + this.accountOwnershipType + ", fingerprint=" + this.fingerprint + ", country=" + this.country + ", statementDescription=" + this.statementDescription + ", achDetails=" + this.achDetails + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().achDetails(this.getAchDetails());
        builder.bankName = this.internalGetBankName();
        builder.transferType = this.internalGetTransferType();
        builder.accountOwnershipType = this.internalGetAccountOwnershipType();
        builder.fingerprint = this.internalGetFingerprint();
        builder.country = this.internalGetCountry();
        builder.statementDescription = this.internalGetStatementDescription();
        builder.errors = this.internalGetErrors();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> bankName;
        private OptionalNullable<String> transferType;
        private OptionalNullable<String> accountOwnershipType;
        private OptionalNullable<String> fingerprint;
        private OptionalNullable<String> country;
        private OptionalNullable<String> statementDescription;
        private ACHDetails achDetails;
        private OptionalNullable<List<Error>> errors;

        public Builder bankName(String bankName) {
            this.bankName = OptionalNullable.of((Object)bankName);
            return this;
        }

        public Builder unsetBankName() {
            this.bankName = null;
            return this;
        }

        public Builder transferType(String transferType) {
            this.transferType = OptionalNullable.of((Object)transferType);
            return this;
        }

        public Builder unsetTransferType() {
            this.transferType = null;
            return this;
        }

        public Builder accountOwnershipType(String accountOwnershipType) {
            this.accountOwnershipType = OptionalNullable.of((Object)accountOwnershipType);
            return this;
        }

        public Builder unsetAccountOwnershipType() {
            this.accountOwnershipType = null;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = OptionalNullable.of((Object)fingerprint);
            return this;
        }

        public Builder unsetFingerprint() {
            this.fingerprint = null;
            return this;
        }

        public Builder country(String country) {
            this.country = OptionalNullable.of((Object)country);
            return this;
        }

        public Builder unsetCountry() {
            this.country = null;
            return this;
        }

        public Builder statementDescription(String statementDescription) {
            this.statementDescription = OptionalNullable.of((Object)statementDescription);
            return this;
        }

        public Builder unsetStatementDescription() {
            this.statementDescription = null;
            return this;
        }

        public Builder achDetails(ACHDetails achDetails) {
            this.achDetails = achDetails;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = OptionalNullable.of(errors);
            return this;
        }

        public Builder unsetErrors() {
            this.errors = null;
            return this;
        }

        public BankAccountPaymentDetails build() {
            return new BankAccountPaymentDetails(this.bankName, this.transferType, this.accountOwnershipType, this.fingerprint, this.country, this.statementDescription, this.achDetails, this.errors);
        }
    }
}

