/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.Error;
import com.squareup.square.models.InventoryChange;
import com.squareup.square.models.InventoryCount;
import java.util.List;
import java.util.Objects;

public class BatchChangeInventoryResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<InventoryCount> counts;
    private final List<InventoryChange> changes;

    @JsonCreator
    public BatchChangeInventoryResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="counts") List<InventoryCount> counts, @JsonProperty(value="changes") List<InventoryChange> changes) {
        this.errors = errors;
        this.counts = counts;
        this.changes = changes;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="counts")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<InventoryCount> getCounts() {
        return this.counts;
    }

    @JsonGetter(value="changes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<InventoryChange> getChanges() {
        return this.changes;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.counts, this.changes);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchChangeInventoryResponse)) {
            return false;
        }
        BatchChangeInventoryResponse other = (BatchChangeInventoryResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.counts, other.counts) && Objects.equals(this.changes, other.changes);
    }

    public String toString() {
        return "BatchChangeInventoryResponse [errors=" + this.errors + ", counts=" + this.counts + ", changes=" + this.changes + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).counts(this.getCounts()).changes(this.getChanges());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<InventoryCount> counts;
        private List<InventoryChange> changes;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder counts(List<InventoryCount> counts) {
            this.counts = counts;
            return this;
        }

        public Builder changes(List<InventoryChange> changes) {
            this.changes = changes;
            return this;
        }

        public BatchChangeInventoryResponse build() {
            BatchChangeInventoryResponse model = new BatchChangeInventoryResponse(this.errors, this.counts, this.changes);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

