/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class BatchDeleteCatalogObjectsRequest {
    private final OptionalNullable<List<String>> objectIds;

    @JsonCreator
    public BatchDeleteCatalogObjectsRequest(@JsonProperty(value="object_ids") List<String> objectIds) {
        this.objectIds = OptionalNullable.of(objectIds);
    }

    protected BatchDeleteCatalogObjectsRequest(OptionalNullable<List<String>> objectIds) {
        this.objectIds = objectIds;
    }

    @JsonGetter(value="object_ids")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<String>> internalGetObjectIds() {
        return this.objectIds;
    }

    @JsonIgnore
    public List<String> getObjectIds() {
        return (List)OptionalNullable.getFrom(this.objectIds);
    }

    public int hashCode() {
        return Objects.hash(this.objectIds);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchDeleteCatalogObjectsRequest)) {
            return false;
        }
        BatchDeleteCatalogObjectsRequest other = (BatchDeleteCatalogObjectsRequest)obj;
        return Objects.equals(this.objectIds, other.objectIds);
    }

    public String toString() {
        return "BatchDeleteCatalogObjectsRequest [objectIds=" + this.objectIds + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.objectIds = this.internalGetObjectIds();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<List<String>> objectIds;

        public Builder objectIds(List<String> objectIds) {
            this.objectIds = OptionalNullable.of(objectIds);
            return this;
        }

        public Builder unsetObjectIds() {
            this.objectIds = null;
            return this;
        }

        public BatchDeleteCatalogObjectsRequest build() {
            return new BatchDeleteCatalogObjectsRequest(this.objectIds);
        }
    }
}

