/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.http.client.HttpContext;
import com.squareup.square.models.CatalogObject;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class BatchRetrieveCatalogObjectsResponse {
    private HttpContext httpContext;
    private final List<Error> errors;
    private final List<CatalogObject> objects;
    private final List<CatalogObject> relatedObjects;

    @JsonCreator
    public BatchRetrieveCatalogObjectsResponse(@JsonProperty(value="errors") List<Error> errors, @JsonProperty(value="objects") List<CatalogObject> objects, @JsonProperty(value="related_objects") List<CatalogObject> relatedObjects) {
        this.errors = errors;
        this.objects = objects;
        this.relatedObjects = relatedObjects;
    }

    @JsonIgnore
    public HttpContext getContext() {
        return this.httpContext;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    @JsonGetter(value="objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogObject> getObjects() {
        return this.objects;
    }

    @JsonGetter(value="related_objects")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<CatalogObject> getRelatedObjects() {
        return this.relatedObjects;
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.objects, this.relatedObjects);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchRetrieveCatalogObjectsResponse)) {
            return false;
        }
        BatchRetrieveCatalogObjectsResponse other = (BatchRetrieveCatalogObjectsResponse)obj;
        return Objects.equals(this.errors, other.errors) && Objects.equals(this.objects, other.objects) && Objects.equals(this.relatedObjects, other.relatedObjects);
    }

    public String toString() {
        return "BatchRetrieveCatalogObjectsResponse [errors=" + this.errors + ", objects=" + this.objects + ", relatedObjects=" + this.relatedObjects + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().errors(this.getErrors()).objects(this.getObjects()).relatedObjects(this.getRelatedObjects());
        return builder;
    }

    public static class Builder {
        private HttpContext httpContext;
        private List<Error> errors;
        private List<CatalogObject> objects;
        private List<CatalogObject> relatedObjects;

        public Builder httpContext(HttpContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public Builder objects(List<CatalogObject> objects) {
            this.objects = objects;
            return this;
        }

        public Builder relatedObjects(List<CatalogObject> relatedObjects) {
            this.relatedObjects = relatedObjects;
            return this;
        }

        public BatchRetrieveCatalogObjectsResponse build() {
            BatchRetrieveCatalogObjectsResponse model = new BatchRetrieveCatalogObjectsResponse(this.errors, this.objects, this.relatedObjects);
            model.httpContext = this.httpContext;
            return model;
        }
    }
}

