/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.CatalogObjectBatch;
import java.util.List;
import java.util.Objects;

public class BatchUpsertCatalogObjectsRequest {
    private final String idempotencyKey;
    private final List<CatalogObjectBatch> batches;

    @JsonCreator
    public BatchUpsertCatalogObjectsRequest(@JsonProperty(value="idempotency_key") String idempotencyKey, @JsonProperty(value="batches") List<CatalogObjectBatch> batches) {
        this.idempotencyKey = idempotencyKey;
        this.batches = batches;
    }

    @JsonGetter(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonGetter(value="batches")
    public List<CatalogObjectBatch> getBatches() {
        return this.batches;
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.batches);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BatchUpsertCatalogObjectsRequest)) {
            return false;
        }
        BatchUpsertCatalogObjectsRequest other = (BatchUpsertCatalogObjectsRequest)obj;
        return Objects.equals(this.idempotencyKey, other.idempotencyKey) && Objects.equals(this.batches, other.batches);
    }

    public String toString() {
        return "BatchUpsertCatalogObjectsRequest [idempotencyKey=" + this.idempotencyKey + ", batches=" + this.batches + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.idempotencyKey, this.batches);
        return builder;
    }

    public static class Builder {
        private String idempotencyKey;
        private List<CatalogObjectBatch> batches;

        public Builder(String idempotencyKey, List<CatalogObjectBatch> batches) {
            this.idempotencyKey = idempotencyKey;
            this.batches = batches;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        public Builder batches(List<CatalogObjectBatch> batches) {
            this.batches = batches;
            return this;
        }

        public BatchUpsertCatalogObjectsRequest build() {
            return new BatchUpsertCatalogObjectsRequest(this.idempotencyKey, this.batches);
        }
    }
}

