/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class BookingCustomAttributeDeleteRequest {
    private final String bookingId;
    private final String key;

    @JsonCreator
    public BookingCustomAttributeDeleteRequest(@JsonProperty(value="booking_id") String bookingId, @JsonProperty(value="key") String key) {
        this.bookingId = bookingId;
        this.key = key;
    }

    @JsonGetter(value="booking_id")
    public String getBookingId() {
        return this.bookingId;
    }

    @JsonGetter(value="key")
    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        return Objects.hash(this.bookingId, this.key);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BookingCustomAttributeDeleteRequest)) {
            return false;
        }
        BookingCustomAttributeDeleteRequest other = (BookingCustomAttributeDeleteRequest)obj;
        return Objects.equals(this.bookingId, other.bookingId) && Objects.equals(this.key, other.key);
    }

    public String toString() {
        return "BookingCustomAttributeDeleteRequest [bookingId=" + this.bookingId + ", key=" + this.key + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.bookingId, this.key);
        return builder;
    }

    public static class Builder {
        private String bookingId;
        private String key;

        public Builder(String bookingId, String key) {
            this.bookingId = bookingId;
            this.key = key;
        }

        public Builder bookingId(String bookingId) {
            this.bookingId = bookingId;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public BookingCustomAttributeDeleteRequest build() {
            return new BookingCustomAttributeDeleteRequest(this.bookingId, this.key);
        }
    }
}

