/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.square.models.Error;
import java.util.List;
import java.util.Objects;

public class BookingCustomAttributeDeleteResponse {
    private final String bookingId;
    private final List<Error> errors;

    @JsonCreator
    public BookingCustomAttributeDeleteResponse(@JsonProperty(value="booking_id") String bookingId, @JsonProperty(value="errors") List<Error> errors) {
        this.bookingId = bookingId;
        this.errors = errors;
    }

    @JsonGetter(value="booking_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBookingId() {
        return this.bookingId;
    }

    @JsonGetter(value="errors")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<Error> getErrors() {
        return this.errors;
    }

    public int hashCode() {
        return Objects.hash(this.bookingId, this.errors);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BookingCustomAttributeDeleteResponse)) {
            return false;
        }
        BookingCustomAttributeDeleteResponse other = (BookingCustomAttributeDeleteResponse)obj;
        return Objects.equals(this.bookingId, other.bookingId) && Objects.equals(this.errors, other.errors);
    }

    public String toString() {
        return "BookingCustomAttributeDeleteResponse [bookingId=" + this.bookingId + ", errors=" + this.errors + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().bookingId(this.getBookingId()).errors(this.getErrors());
        return builder;
    }

    public static class Builder {
        private String bookingId;
        private List<Error> errors;

        public Builder bookingId(String bookingId) {
            this.bookingId = bookingId;
            return this;
        }

        public Builder errors(List<Error> errors) {
            this.errors = errors;
            return this;
        }

        public BookingCustomAttributeDeleteResponse build() {
            return new BookingCustomAttributeDeleteResponse(this.bookingId, this.errors);
        }
    }
}

