/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CustomAttribute;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class BookingCustomAttributeUpsertRequest {
    private final String bookingId;
    private final CustomAttribute customAttribute;
    private final OptionalNullable<String> idempotencyKey;

    @JsonCreator
    public BookingCustomAttributeUpsertRequest(@JsonProperty(value="booking_id") String bookingId, @JsonProperty(value="custom_attribute") CustomAttribute customAttribute, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.bookingId = bookingId;
        this.customAttribute = customAttribute;
        this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
    }

    protected BookingCustomAttributeUpsertRequest(String bookingId, CustomAttribute customAttribute, OptionalNullable<String> idempotencyKey) {
        this.bookingId = bookingId;
        this.customAttribute = customAttribute;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="booking_id")
    public String getBookingId() {
        return this.bookingId;
    }

    @JsonGetter(value="custom_attribute")
    public CustomAttribute getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonIgnore
    public String getIdempotencyKey() {
        return (String)OptionalNullable.getFrom(this.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.bookingId, this.customAttribute, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BookingCustomAttributeUpsertRequest)) {
            return false;
        }
        BookingCustomAttributeUpsertRequest other = (BookingCustomAttributeUpsertRequest)obj;
        return Objects.equals(this.bookingId, other.bookingId) && Objects.equals(this.customAttribute, other.customAttribute) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "BookingCustomAttributeUpsertRequest [bookingId=" + this.bookingId + ", customAttribute=" + this.customAttribute + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.bookingId, this.customAttribute);
        builder.idempotencyKey = this.internalGetIdempotencyKey();
        return builder;
    }

    public static class Builder {
        private String bookingId;
        private CustomAttribute customAttribute;
        private OptionalNullable<String> idempotencyKey;

        public Builder(String bookingId, CustomAttribute customAttribute) {
            this.bookingId = bookingId;
            this.customAttribute = customAttribute;
        }

        public Builder bookingId(String bookingId) {
            this.bookingId = bookingId;
            return this;
        }

        public Builder customAttribute(CustomAttribute customAttribute) {
            this.customAttribute = customAttribute;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
            return this;
        }

        public Builder unsetIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public BookingCustomAttributeUpsertRequest build() {
            return new BookingCustomAttributeUpsertRequest(this.bookingId, this.customAttribute, this.idempotencyKey);
        }
    }
}

