/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class Break {
    private final String id;
    private final String startAt;
    private final OptionalNullable<String> endAt;
    private final String breakTypeId;
    private final String name;
    private final String expectedDuration;
    private final boolean isPaid;

    @JsonCreator
    public Break(@JsonProperty(value="start_at") String startAt, @JsonProperty(value="break_type_id") String breakTypeId, @JsonProperty(value="name") String name, @JsonProperty(value="expected_duration") String expectedDuration, @JsonProperty(value="is_paid") boolean isPaid, @JsonProperty(value="id") String id, @JsonProperty(value="end_at") String endAt) {
        this.id = id;
        this.startAt = startAt;
        this.endAt = OptionalNullable.of((Object)endAt);
        this.breakTypeId = breakTypeId;
        this.name = name;
        this.expectedDuration = expectedDuration;
        this.isPaid = isPaid;
    }

    protected Break(String startAt, String breakTypeId, String name, String expectedDuration, boolean isPaid, String id, OptionalNullable<String> endAt) {
        this.id = id;
        this.startAt = startAt;
        this.endAt = endAt;
        this.breakTypeId = breakTypeId;
        this.name = name;
        this.expectedDuration = expectedDuration;
        this.isPaid = isPaid;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="start_at")
    public String getStartAt() {
        return this.startAt;
    }

    @JsonGetter(value="end_at")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetEndAt() {
        return this.endAt;
    }

    @JsonIgnore
    public String getEndAt() {
        return (String)OptionalNullable.getFrom(this.endAt);
    }

    @JsonGetter(value="break_type_id")
    public String getBreakTypeId() {
        return this.breakTypeId;
    }

    @JsonGetter(value="name")
    public String getName() {
        return this.name;
    }

    @JsonGetter(value="expected_duration")
    public String getExpectedDuration() {
        return this.expectedDuration;
    }

    @JsonGetter(value="is_paid")
    public boolean getIsPaid() {
        return this.isPaid;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.startAt, this.endAt, this.breakTypeId, this.name, this.expectedDuration, this.isPaid);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Break)) {
            return false;
        }
        Break other = (Break)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.startAt, other.startAt) && Objects.equals(this.endAt, other.endAt) && Objects.equals(this.breakTypeId, other.breakTypeId) && Objects.equals(this.name, other.name) && Objects.equals(this.expectedDuration, other.expectedDuration) && Objects.equals(this.isPaid, other.isPaid);
    }

    public String toString() {
        return "Break [startAt=" + this.startAt + ", breakTypeId=" + this.breakTypeId + ", name=" + this.name + ", expectedDuration=" + this.expectedDuration + ", isPaid=" + this.isPaid + ", id=" + this.id + ", endAt=" + this.endAt + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.startAt, this.breakTypeId, this.name, this.expectedDuration, this.isPaid).id(this.getId());
        builder.endAt = this.internalGetEndAt();
        return builder;
    }

    public static class Builder {
        private String startAt;
        private String breakTypeId;
        private String name;
        private String expectedDuration;
        private boolean isPaid;
        private String id;
        private OptionalNullable<String> endAt;

        public Builder(String startAt, String breakTypeId, String name, String expectedDuration, boolean isPaid) {
            this.startAt = startAt;
            this.breakTypeId = breakTypeId;
            this.name = name;
            this.expectedDuration = expectedDuration;
            this.isPaid = isPaid;
        }

        public Builder startAt(String startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder breakTypeId(String breakTypeId) {
            this.breakTypeId = breakTypeId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder expectedDuration(String expectedDuration) {
            this.expectedDuration = expectedDuration;
            return this;
        }

        public Builder isPaid(boolean isPaid) {
            this.isPaid = isPaid;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder endAt(String endAt) {
            this.endAt = OptionalNullable.of((Object)endAt);
            return this;
        }

        public Builder unsetEndAt() {
            this.endAt = null;
            return this;
        }

        public Break build() {
            return new Break(this.startAt, this.breakTypeId, this.name, this.expectedDuration, this.isPaid, this.id, this.endAt);
        }
    }
}

