/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CustomAttribute;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class BulkUpsertLocationCustomAttributesRequestLocationCustomAttributeUpsertRequest {
    private final String locationId;
    private final CustomAttribute customAttribute;
    private final OptionalNullable<String> idempotencyKey;

    @JsonCreator
    public BulkUpsertLocationCustomAttributesRequestLocationCustomAttributeUpsertRequest(@JsonProperty(value="location_id") String locationId, @JsonProperty(value="custom_attribute") CustomAttribute customAttribute, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.locationId = locationId;
        this.customAttribute = customAttribute;
        this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
    }

    protected BulkUpsertLocationCustomAttributesRequestLocationCustomAttributeUpsertRequest(String locationId, CustomAttribute customAttribute, OptionalNullable<String> idempotencyKey) {
        this.locationId = locationId;
        this.customAttribute = customAttribute;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonGetter(value="custom_attribute")
    public CustomAttribute getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonIgnore
    public String getIdempotencyKey() {
        return (String)OptionalNullable.getFrom(this.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.customAttribute, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BulkUpsertLocationCustomAttributesRequestLocationCustomAttributeUpsertRequest)) {
            return false;
        }
        BulkUpsertLocationCustomAttributesRequestLocationCustomAttributeUpsertRequest other = (BulkUpsertLocationCustomAttributesRequestLocationCustomAttributeUpsertRequest)obj;
        return Objects.equals(this.locationId, other.locationId) && Objects.equals(this.customAttribute, other.customAttribute) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "BulkUpsertLocationCustomAttributesRequestLocationCustomAttributeUpsertRequest [locationId=" + this.locationId + ", customAttribute=" + this.customAttribute + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.locationId, this.customAttribute);
        builder.idempotencyKey = this.internalGetIdempotencyKey();
        return builder;
    }

    public static class Builder {
        private String locationId;
        private CustomAttribute customAttribute;
        private OptionalNullable<String> idempotencyKey;

        public Builder(String locationId, CustomAttribute customAttribute) {
            this.locationId = locationId;
            this.customAttribute = customAttribute;
        }

        public Builder locationId(String locationId) {
            this.locationId = locationId;
            return this;
        }

        public Builder customAttribute(CustomAttribute customAttribute) {
            this.customAttribute = customAttribute;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
            return this;
        }

        public Builder unsetIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public BulkUpsertLocationCustomAttributesRequestLocationCustomAttributeUpsertRequest build() {
            return new BulkUpsertLocationCustomAttributesRequestLocationCustomAttributeUpsertRequest(this.locationId, this.customAttribute, this.idempotencyKey);
        }
    }
}

