/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.CustomAttribute;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class BulkUpsertMerchantCustomAttributesRequestMerchantCustomAttributeUpsertRequest {
    private final String merchantId;
    private final CustomAttribute customAttribute;
    private final OptionalNullable<String> idempotencyKey;

    @JsonCreator
    public BulkUpsertMerchantCustomAttributesRequestMerchantCustomAttributeUpsertRequest(@JsonProperty(value="merchant_id") String merchantId, @JsonProperty(value="custom_attribute") CustomAttribute customAttribute, @JsonProperty(value="idempotency_key") String idempotencyKey) {
        this.merchantId = merchantId;
        this.customAttribute = customAttribute;
        this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
    }

    protected BulkUpsertMerchantCustomAttributesRequestMerchantCustomAttributeUpsertRequest(String merchantId, CustomAttribute customAttribute, OptionalNullable<String> idempotencyKey) {
        this.merchantId = merchantId;
        this.customAttribute = customAttribute;
        this.idempotencyKey = idempotencyKey;
    }

    @JsonGetter(value="merchant_id")
    public String getMerchantId() {
        return this.merchantId;
    }

    @JsonGetter(value="custom_attribute")
    public CustomAttribute getCustomAttribute() {
        return this.customAttribute;
    }

    @JsonGetter(value="idempotency_key")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonIgnore
    public String getIdempotencyKey() {
        return (String)OptionalNullable.getFrom(this.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.merchantId, this.customAttribute, this.idempotencyKey);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BulkUpsertMerchantCustomAttributesRequestMerchantCustomAttributeUpsertRequest)) {
            return false;
        }
        BulkUpsertMerchantCustomAttributesRequestMerchantCustomAttributeUpsertRequest other = (BulkUpsertMerchantCustomAttributesRequestMerchantCustomAttributeUpsertRequest)obj;
        return Objects.equals(this.merchantId, other.merchantId) && Objects.equals(this.customAttribute, other.customAttribute) && Objects.equals(this.idempotencyKey, other.idempotencyKey);
    }

    public String toString() {
        return "BulkUpsertMerchantCustomAttributesRequestMerchantCustomAttributeUpsertRequest [merchantId=" + this.merchantId + ", customAttribute=" + this.customAttribute + ", idempotencyKey=" + this.idempotencyKey + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.merchantId, this.customAttribute);
        builder.idempotencyKey = this.internalGetIdempotencyKey();
        return builder;
    }

    public static class Builder {
        private String merchantId;
        private CustomAttribute customAttribute;
        private OptionalNullable<String> idempotencyKey;

        public Builder(String merchantId, CustomAttribute customAttribute) {
            this.merchantId = merchantId;
            this.customAttribute = customAttribute;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder customAttribute(CustomAttribute customAttribute) {
            this.customAttribute = customAttribute;
            return this;
        }

        public Builder idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = OptionalNullable.of((Object)idempotencyKey);
            return this;
        }

        public Builder unsetIdempotencyKey() {
            this.idempotencyKey = null;
            return this;
        }

        public BulkUpsertMerchantCustomAttributesRequestMerchantCustomAttributeUpsertRequest build() {
            return new BulkUpsertMerchantCustomAttributesRequestMerchantCustomAttributeUpsertRequest(this.merchantId, this.customAttribute, this.idempotencyKey);
        }
    }
}

