/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.AfterpayDetails;
import com.squareup.square.models.ClearpayDetails;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class BuyNowPayLaterDetails {
    private final OptionalNullable<String> brand;
    private final AfterpayDetails afterpayDetails;
    private final ClearpayDetails clearpayDetails;

    @JsonCreator
    public BuyNowPayLaterDetails(@JsonProperty(value="brand") String brand, @JsonProperty(value="afterpay_details") AfterpayDetails afterpayDetails, @JsonProperty(value="clearpay_details") ClearpayDetails clearpayDetails) {
        this.brand = OptionalNullable.of((Object)brand);
        this.afterpayDetails = afterpayDetails;
        this.clearpayDetails = clearpayDetails;
    }

    protected BuyNowPayLaterDetails(OptionalNullable<String> brand, AfterpayDetails afterpayDetails, ClearpayDetails clearpayDetails) {
        this.brand = brand;
        this.afterpayDetails = afterpayDetails;
        this.clearpayDetails = clearpayDetails;
    }

    @JsonGetter(value="brand")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetBrand() {
        return this.brand;
    }

    @JsonIgnore
    public String getBrand() {
        return (String)OptionalNullable.getFrom(this.brand);
    }

    @JsonGetter(value="afterpay_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AfterpayDetails getAfterpayDetails() {
        return this.afterpayDetails;
    }

    @JsonGetter(value="clearpay_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ClearpayDetails getClearpayDetails() {
        return this.clearpayDetails;
    }

    public int hashCode() {
        return Objects.hash(this.brand, this.afterpayDetails, this.clearpayDetails);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BuyNowPayLaterDetails)) {
            return false;
        }
        BuyNowPayLaterDetails other = (BuyNowPayLaterDetails)obj;
        return Objects.equals(this.brand, other.brand) && Objects.equals(this.afterpayDetails, other.afterpayDetails) && Objects.equals(this.clearpayDetails, other.clearpayDetails);
    }

    public String toString() {
        return "BuyNowPayLaterDetails [brand=" + this.brand + ", afterpayDetails=" + this.afterpayDetails + ", clearpayDetails=" + this.clearpayDetails + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().afterpayDetails(this.getAfterpayDetails()).clearpayDetails(this.getClearpayDetails());
        builder.brand = this.internalGetBrand();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> brand;
        private AfterpayDetails afterpayDetails;
        private ClearpayDetails clearpayDetails;

        public Builder brand(String brand) {
            this.brand = OptionalNullable.of((Object)brand);
            return this;
        }

        public Builder unsetBrand() {
            this.brand = null;
            return this;
        }

        public Builder afterpayDetails(AfterpayDetails afterpayDetails) {
            this.afterpayDetails = afterpayDetails;
            return this;
        }

        public Builder clearpayDetails(ClearpayDetails clearpayDetails) {
            this.clearpayDetails = clearpayDetails;
            return this;
        }

        public BuyNowPayLaterDetails build() {
            return new BuyNowPayLaterDetails(this.brand, this.afterpayDetails, this.clearpayDetails);
        }
    }
}

