/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Money;
import io.apimatic.core.types.OptionalNullable;
import java.util.Objects;

public class CalculateLoyaltyPointsRequest {
    private final OptionalNullable<String> orderId;
    private final Money transactionAmountMoney;
    private final OptionalNullable<String> loyaltyAccountId;

    @JsonCreator
    public CalculateLoyaltyPointsRequest(@JsonProperty(value="order_id") String orderId, @JsonProperty(value="transaction_amount_money") Money transactionAmountMoney, @JsonProperty(value="loyalty_account_id") String loyaltyAccountId) {
        this.orderId = OptionalNullable.of((Object)orderId);
        this.transactionAmountMoney = transactionAmountMoney;
        this.loyaltyAccountId = OptionalNullable.of((Object)loyaltyAccountId);
    }

    protected CalculateLoyaltyPointsRequest(OptionalNullable<String> orderId, Money transactionAmountMoney, OptionalNullable<String> loyaltyAccountId) {
        this.orderId = orderId;
        this.transactionAmountMoney = transactionAmountMoney;
        this.loyaltyAccountId = loyaltyAccountId;
    }

    @JsonGetter(value="order_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetOrderId() {
        return this.orderId;
    }

    @JsonIgnore
    public String getOrderId() {
        return (String)OptionalNullable.getFrom(this.orderId);
    }

    @JsonGetter(value="transaction_amount_money")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTransactionAmountMoney() {
        return this.transactionAmountMoney;
    }

    @JsonGetter(value="loyalty_account_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<String> internalGetLoyaltyAccountId() {
        return this.loyaltyAccountId;
    }

    @JsonIgnore
    public String getLoyaltyAccountId() {
        return (String)OptionalNullable.getFrom(this.loyaltyAccountId);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.transactionAmountMoney, this.loyaltyAccountId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CalculateLoyaltyPointsRequest)) {
            return false;
        }
        CalculateLoyaltyPointsRequest other = (CalculateLoyaltyPointsRequest)obj;
        return Objects.equals(this.orderId, other.orderId) && Objects.equals(this.transactionAmountMoney, other.transactionAmountMoney) && Objects.equals(this.loyaltyAccountId, other.loyaltyAccountId);
    }

    public String toString() {
        return "CalculateLoyaltyPointsRequest [orderId=" + this.orderId + ", transactionAmountMoney=" + this.transactionAmountMoney + ", loyaltyAccountId=" + this.loyaltyAccountId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().transactionAmountMoney(this.getTransactionAmountMoney());
        builder.orderId = this.internalGetOrderId();
        builder.loyaltyAccountId = this.internalGetLoyaltyAccountId();
        return builder;
    }

    public static class Builder {
        private OptionalNullable<String> orderId;
        private Money transactionAmountMoney;
        private OptionalNullable<String> loyaltyAccountId;

        public Builder orderId(String orderId) {
            this.orderId = OptionalNullable.of((Object)orderId);
            return this;
        }

        public Builder unsetOrderId() {
            this.orderId = null;
            return this;
        }

        public Builder transactionAmountMoney(Money transactionAmountMoney) {
            this.transactionAmountMoney = transactionAmountMoney;
            return this;
        }

        public Builder loyaltyAccountId(String loyaltyAccountId) {
            this.loyaltyAccountId = OptionalNullable.of((Object)loyaltyAccountId);
            return this;
        }

        public Builder unsetLoyaltyAccountId() {
            this.loyaltyAccountId = null;
            return this;
        }

        public CalculateLoyaltyPointsRequest build() {
            return new CalculateLoyaltyPointsRequest(this.orderId, this.transactionAmountMoney, this.loyaltyAccountId);
        }
    }
}

