/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.squareup.square.models.Order;
import com.squareup.square.models.OrderReward;
import io.apimatic.core.types.OptionalNullable;
import java.util.List;
import java.util.Objects;

public class CalculateOrderRequest {
    private final Order order;
    private final OptionalNullable<List<OrderReward>> proposedRewards;

    @JsonCreator
    public CalculateOrderRequest(@JsonProperty(value="order") Order order, @JsonProperty(value="proposed_rewards") List<OrderReward> proposedRewards) {
        this.order = order;
        this.proposedRewards = OptionalNullable.of(proposedRewards);
    }

    protected CalculateOrderRequest(Order order, OptionalNullable<List<OrderReward>> proposedRewards) {
        this.order = order;
        this.proposedRewards = proposedRewards;
    }

    @JsonGetter(value="order")
    public Order getOrder() {
        return this.order;
    }

    @JsonGetter(value="proposed_rewards")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=OptionalNullable.Serializer.class)
    protected OptionalNullable<List<OrderReward>> internalGetProposedRewards() {
        return this.proposedRewards;
    }

    @JsonIgnore
    public List<OrderReward> getProposedRewards() {
        return (List)OptionalNullable.getFrom(this.proposedRewards);
    }

    public int hashCode() {
        return Objects.hash(this.order, this.proposedRewards);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CalculateOrderRequest)) {
            return false;
        }
        CalculateOrderRequest other = (CalculateOrderRequest)obj;
        return Objects.equals(this.order, other.order) && Objects.equals(this.proposedRewards, other.proposedRewards);
    }

    public String toString() {
        return "CalculateOrderRequest [order=" + this.order + ", proposedRewards=" + this.proposedRewards + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.order);
        builder.proposedRewards = this.internalGetProposedRewards();
        return builder;
    }

    public static class Builder {
        private Order order;
        private OptionalNullable<List<OrderReward>> proposedRewards;

        public Builder(Order order) {
            this.order = order;
        }

        public Builder order(Order order) {
            this.order = order;
            return this;
        }

        public Builder proposedRewards(List<OrderReward> proposedRewards) {
            this.proposedRewards = OptionalNullable.of(proposedRewards);
            return this;
        }

        public Builder unsetProposedRewards() {
            this.proposedRewards = null;
            return this;
        }

        public CalculateOrderRequest build() {
            return new CalculateOrderRequest(this.order, this.proposedRewards);
        }
    }
}

